<?php

namespace Dmkzwo\ContaoVideoBundle\Elements;



class ContentYoutube extends \ContentYouTube
{

    protected $strTemplate = 'ce_dzyoutube';
    protected $baseCssClass = 'ce_dzyoutube';

    public function generate()
    {
        if (file_exists(TL_ROOT . '/templates/ww_theme/ce_dzyoutube_' . $this->dzSubtype . '.html5')) {
            $this->strTemplate = 'ce_dzyoutube_' . $this->dzSubtype;
        }

        return parent::generate();
    }

    protected function compile()
    {
        parent::compile();

        $this->Template->videoSrc = $this->Template->src;

        $arrAddClass = [];

        // add image
        if ($this->singleSRC != '') {
            $objModel = \FilesModel::findByUuid($this->singleSRC);
            if ($objModel !== null && is_file(\System::getContainer()->getParameter('kernel.project_dir') . '/' . $objModel->path)) {
                $this->singleSRC = $objModel->path;
                $this->addImageToTemplate($this->Template, $this->arrData, null, null, $objModel);
            }
        }

        // add background image
        if ($this->dzVideoBgSrc != '') {
            $objModel = \FilesModel::findByUuid($this->dzVideoBgSrc);
            if ($objModel !== null && is_file(\System::getContainer()->getParameter('kernel.project_dir') . '/' . $objModel->path)) {
                $this->Template->dzVideoBgSrc = $objModel->path;
                $arrAddClass[] = $this->baseCssClass . '--with-bg-image';
            } else {
                $arrAddClass[] = $this->baseCssClass . '--wo-bg-image';
            }
        } else {
            $arrAddClass[] = $this->baseCssClass . '--wo-bg-image';
        }

        // modal fields

        $arrModalHeadline = \StringUtil::deserialize($this->dzVideoModalHeadline);

        $this->Template->headlineModal = \is_array($arrModalHeadline) ? $arrModalHeadline['value'] : $arrModalHeadline;
        $this->Template->hlModal = \is_array($arrModalHeadline) ? $arrModalHeadline['unit'] : 'h1';

        $this->Template->baseCssClass = $this->baseCssClass;

        $arrAddClass[] =  $this->baseCssClass . '--keycolor-' . $this->dzGeneralKeycolor;

        $this->Template->addClass = implode(' ', $arrAddClass);

    }
}

class_alias(ContentYoutube::class, 'ContentDzYoutube');
