<?php


namespace Dmkzwo\ContaoTranslationBundle\Module;


use Dmkzwo\ContaoTranslationBundle\Library\ExportHelper;
use Dmkzwo\ContaoTranslationBundle\Library\TranslationHelper;

class FilesBackendModule extends \BackendModule
{
    protected $strTemplate = 'be_dztranslation_files';

    public function generate()
    {
        return parent::generate();
    }


    public function compile()
    {

        $translationHelper = new TranslationHelper();

        if ($this->Input->get('key') == 'exportall') {
            $translationHelper->copySourceFiles();
            $translationHelper->exportAll();
        }

        $download = $this->Input->get('download');
        if ($download) {
            ExportHelper::exportXlsx($translationHelper->getExportDir(), $download);
        }

        $translations = [];

        $sourceFiles = $translationHelper->getSourceFiles();

        foreach ($sourceFiles as $file) {
            $translation = [];
            $translation['file'] = $file;
            $translation['exportFiles'] = $translationHelper->getTranslationFiles($file);

            $translations[] = $translation;
        }

        $this->Template->translations = $translations;
//        var_dump($translations);
//        $log = \Input::get('log');

//        if ($log) {
//
//            $logFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . \System::getContainer()->getParameter('dakks.as_log_dir') . DIRECTORY_SEPARATOR . $log;
//
////            $logContent = file_get_contents($logFile);
////            $logContent = str_replace("\n", '<br>', $logContent);
//
//            $logContentLines = file($logFile);
//            $logContent = '<table>';
//            foreach ($logContentLines as $logContentLine) {
//                $logParts = explode('##', $logContentLine);
//                $logParts[0] = '<a href="/dev/xml/' . str_replace('.xml', '', $logParts[0]) . '" target="_blank">'.$logParts[0].'</a>';
//                $logContentLine = implode('##', $logParts);
//                $logContent .= '<tr><td>' . str_replace('##', '</td><td>', $logContentLine) . '</td></tr>';
//            }
//            $logContent .= '</table>';
//
//            $this->Template->headline = $log;
//            $this->Template->logContent = $logContent;
//            $this->Template->isDetail = true;
//            $this->Template->href = $this->getReferer(true);
//
//        } else {
//
//            $logFiles = $this->getLatestLogfiles();
//
//            $this->Template->logFiles = $logFiles;
//            $this->Template->headline = 'Übersicht';
//            $this->Template->isDetail = false;
//        }


    }

}
