<?php


use Contao\CoreBundle\DataContainer\PaletteManipulator;

// Extend the default palettes
PaletteManipulator::create()
    ->addLegend('dztimeline_legend', 'amg_legend', PaletteManipulator::POSITION_BEFORE)
    ->addField(array('dztimelines', 'dztimelinep'), 'dztimeline_legend', PaletteManipulator::POSITION_APPEND)
    ->applyToPalette('default', 'tl_user_group')
;

// Add fields to tl_user
$GLOBALS['TL_DCA']['tl_user_group']['fields']['dztimelines'] = array
(
    'exclude'                 => true,
    'inputType'               => 'checkbox',
    'foreignKey'              => 'tl_timeline.title',
    'eval'                    => array('multiple'=>true),
    'sql'                     => "blob NULL"
);


$GLOBALS['TL_DCA']['tl_user_group']['fields']['dztimelinep'] = array
(
    'exclude'                 => true,
    'inputType'               => 'checkbox',
    'options'                 => array('create', 'delete'),
    'reference'               => &$GLOBALS['TL_LANG']['MSC'],
    'eval'                    => array('multiple'=>true),
    'sql'                     => "blob NULL"
);


