$(function () {
    // Process each tab group
    var init = function () {
        addEventlisteners();
    };

    var addEventlisteners = function() {
        $('.js-toggle-tli a').on('click', function(event) {
            event.stopPropagation();
        });

        $('.js-toggle-tli').on('click', function(event) {
            event.preventDefault();

            var target = event.currentTarget;
            var targetId = $(target).attr('aria-controls');

            $('#' + targetId).slideToggle();
            $(target).attr('aria-expanded', ($(target).attr('aria-expanded') === 'true') ? 'false' : 'true');
        });
    };

    // Button version
    /*
    var addEventlisteners = function() {
        $('.js-toggle-tli').on('click', function(event) {
            event.preventDefault();
            var target = event.currentTarget;

            var targetId = $(target).attr('aria-controls');
            console.log(targetId);

            $('#' + targetId).slideToggle();
            $(target).attr('aria-expanded', ($(target).attr('aria-expanded') === 'true') ? 'false' : 'true');
        });
    };
     */

    init();
});



