<?php

namespace Dmkzwo\ContaoTimelineBundle\Model;


class TimelineItemModel extends \Model
{
    /**
     * Table name
     * @var string
     */
    protected static $strTable = 'tl_timeline_item';

    public static function getItemTypes()
    {
        return [
            'standard' => 'Standard',
            'photo' => 'Foto',
            'correspondent' => 'Korrespondent',
            'podcast' => 'Podcast',
            'phototext' => 'Text auf Bild',
            'quote' => 'Zitat',
            'story' => 'Erfahrungsbericht',
            'facts' => 'Fakten',
            'youtube' => 'Youtube',
            'instagram' => 'Instagram',
        ];
    }

    public static function countPublishedByTimelineId($timelineId): int
    {
        return TimelineItemModel::countBy(
            ['pid=?', 'published=?'],
            [$timelineId, '1']
        );
    }

    public static function findPublishedbyTimelineId($timelineId)
    {
        $queryOptions = [
            'order' => 'sorting',
        ];

        return TimelineItemModel::findBy(
            ['pid=?', 'published=?'],
            [$timelineId, '1'],
            $queryOptions
        );
    }
}

class_alias(TimelineItemModel::class, 'TimelineItemModel');
