<?php

namespace Dmkzwo\ContaoTimelineBundle\Elements;

use Contao\ContentModel;
use Contao\CoreBundle\Controller\ContentElement\AbstractContentElementController;
use Contao\CoreBundle\ServiceAnnotation\ContentElement;
use Contao\Template;
use Dmkzwo\ContaoTimelineBundle\Model\TimelineItemModel;
use Dmkzwo\ContaoTimelineBundle\Model\TimelineModel;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @ContentElement(TimelineElementController::TYPE)
 */
class TimelineElementController extends AbstractContentElementController
{
    public const TYPE = 'timeline_element';

    protected $template;
    protected $model;

    protected $baseCssClass = 'ce_timeline';


    protected function getResponse(Template $template, ContentModel $model, Request $request): ?Response
    {
        $this->template = $template;
        $this->model = $model;

        $objTimeline = TimelineModel::findByPk($model->dzTimeline);
        $template->timeline = $objTimeline;

        if ($objTimeline) {
            $timelineItems = TimelineItemModel::findPublishedbyTimelineId($objTimeline->id);
            $template->timelineItems = $timelineItems;
        }

        $template->hlNextLevel = $template->hl ? ('h' . (intval(substr($template->hl, 1, 1)) + 1) ) : 'h3';
        $template->hlOvernextLevel = $template->hl ? ('h' . (intval(substr($template->hl, 1, 1)) + 2) ) : 'h4';
        $template->noDate = !strlen(trim($model->dateStr));

        $template->baseCssClass = $this->baseCssClass;

        return $template->getResponse();
    }


}

