<?php

\System::loadLanguageFile('tl_content');

$GLOBALS['TL_DCA']['tl_timeline_item'] = array
(
    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'ptable' => 'tl_timeline',
        'enableVersioning' => true,
        'markAsCopy' => 'title',
        'onload_callback' => array
        (
            array('tl_timeline_item', 'checkPermission')
        ),
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'pid,published,sorting' => 'index'
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 4,
            'fields' => array('sorting'),
            'panelLayout' => 'filter;search,limit',
            'headerFields' => array('title', 'itemType'),
            'child_record_callback' => array('tl_timeline_item', 'listTitles')
        ),
        'global_operations' => array
        (
            'all' => array
            (
                'href' => 'act=select',
                'class' => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset()" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'href' => 'act=edit',
                'icon' => 'edit.svg'
            ),
            'copy' => array
            (
                'href' => 'act=paste&amp;mode=copy',
                'icon' => 'copy.svg'
            ),
            'cut' => array
            (
                'href' => 'act=paste&amp;mode=cut',
                'icon' => 'cut.svg'
            ),
            'delete' => array
            (
                'href' => 'act=delete',
                'icon' => 'delete.svg',
                'attributes' => 'onclick="if(!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\'))return false;Backend.getScrollOffset()"'
            ),
            'toggle' => array
            (
                'icon' => 'visible.svg',
                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
                'button_callback' => array('tl_timeline_item', 'toggleIcon')
            ),
            'show' => array
            (
                'href' => 'act=show',
                'icon' => 'show.svg'
            )
        )
    ),

    // Palettes
    'palettes' => array
    (
        'default'      => 'title,published,datestr,headline,text,iconSRC, position,marginBottom,expandable',
//        'default'      => 'itemType,published,title,datestr,headline,text,fileSRC;{link_legend},url,target,linkTitle',
    ),

    // Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment"
        ),
        'pid' => array
        (
            'foreignKey' => 'tl_timeline.title',
            'sql' => "int(10) unsigned NOT NULL default 0",
            'relation' => array('type' => 'belongsTo', 'load' => 'lazy')
        ),
        'sorting' => array
        (
            'label' => &$GLOBALS['TL_LANG']['MSC']['sorting'],
            'sorting' => true,
            'flag' => 11,
            'sql' => "int(10) unsigned NOT NULL default 0"
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default 0"
        ),
        'title' => array
        (
            'search' => true,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'clr long'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),
        'published' => array
        (
            'filter' => true,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
            'sql' => "char(1) NOT NULL default ''"
        ),

        'datestr' => array
        (
            'search' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'clr long'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),

        'headline' => array
        (
            'search' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 255, 'tl_class' => 'clr long'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),

        'text' => array
        (
            'inputType' => 'textarea',
            'eval' => array('mandatory' => false, 'tl_class' => 'clr long', 'rte' => 'tinyMCE', 'helpwizard' => true),
            'sql' => "text NULL"
        ),

        'position' => array
        (
            'search' => false,
            'inputType' => 'radio',
            'options' => array(
                'left' => $GLOBALS['TL_LANG']['tl_timeline_item']['pos_left'],
                'right' => $GLOBALS['TL_LANG']['tl_timeline_item']['pos_right'],
            ),
            'default' => 'left',
            'eval' => array('mandatory' => false, 'tl_class' => 'clr w50'),
            'sql' => "char(10) NOT NULL default 'left'"
        ),

        'marginBottom' => array
        (
            'search' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 3, 'tl_class' => 'w50'),
            'sql' => "char(3) NOT NULL default ''"
        ),

        'iconSRC' => array
        (
            'inputType'               => 'fileTree',
            'eval'                    => array('mandatory' => false, 'fieldType'=>'radio', 'filesOnly'=>true, 'isDownloads'=>true, 'extensions'=>\Config::get('allowedDownload'), 'tl_class' => 'clr'),
            'sql'                     => "binary(16) NULL"
        ),

        'expandable' => array
        (
            'filter' => false,
            'inputType' => 'checkbox',
            'eval' => array('tl_class' => 'w50'),
            'sql' => "char(1) NOT NULL default ''"
        ),

        /*
        'url' => array
        (
            'label'                   => &$GLOBALS['TL_LANG']['MSC']['url'],
            'search'                  => false,
            'inputType'               => 'text',
            'eval'                    => array('mandatory'=>false, 'rgxp'=>'url', 'decodeEntities'=>true, 'maxlength'=>255, 'dcaPicker'=>true, 'addWizardClass'=>false, 'tl_class'=>'w50'),
            'sql'                     => "varchar(255) NOT NULL default ''"
        ),

        'linkTitle' => array
        (
            'search'                  => false,
            'inputType'               => 'text',
            'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
            'sql'                     => "varchar(255) NOT NULL default ''"
        ),

        'target' => array
        (
            'label'                   => &$GLOBALS['TL_LANG']['MSC']['target'],
            'inputType'               => 'checkbox',
            'eval'                    => array('tl_class'=>'w50 m12'),
            'sql'                     => "char(1) NOT NULL default ''"
        ),
        */
    )
);

/**
 * Provide miscellaneous methods that are used by the data configuration array.
 *
 * @author Leo Feyer <https://github.com/leofeyer>
 */
class tl_timeline_item extends \Backend
{
    protected $rowNumber = 0;

    /**
     * Import the back end user object
     */
    public function __construct()
    {
        parent::__construct();
        $this->import('\BackendUser', 'User');
    }

    /**
     * Check permissions to edit table tl_timeline_item
     */
    public function checkPermission()
    {
        $bundles = \System::getContainer()->getParameter('kernel.bundles');

        if ($this->User->isAdmin) {
            return;
        }

        // Set the root IDs
        if (empty($this->User->dztimelines) || !is_array($this->User->dztimelines)) {
            $root = array(0);
        } else {
            $root = $this->User->dztimelines;
        }

        $id = strlen(\Input::get('id')) ? \Input::get('id') : CURRENT_ID;

        // Check current action
        switch (\Input::get('act')) {
            case 'paste':
            case 'select':
                // Check CURRENT_ID here (see #247)
                if (!in_array(CURRENT_ID, $root)) {
                    throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to access timeline item ID ' . $id . '.');
                }
                break;

            case 'create':
                if (!strlen(\Input::get('pid')) || !in_array(\Input::get('pid'), $root)) {
                    throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to create timeline items in Timeline ID ' . \Input::get('pid') . '.');
                }
                break;

            case 'cut':
            case 'copy':
                if (\Input::get('act') == 'cut' && \Input::get('mode') == 1) {
                    $objDocs = $this->Database->prepare("SELECT pid FROM tl_timeline_item WHERE id=?")
                        ->limit(1)
                        ->execute(\Input::get('pid'));

                    if ($objDocs->numRows < 1) {
                        throw new \CoreBundle\Exception\AccessDeniedException('Invalid timeline item ID ' . \Input::get('pid') . '.');
                    }

                    $pid = $objDocs->pid;
                } else {
                    $pid = \Input::get('pid');
                }

                if (!in_array($pid, $root)) {
                    throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to ' . \Input::get('act') . ' timeline item ID ' . $id . ' to timeline ID ' . $pid . '.');
                }
            // no break

            case 'edit':
            case 'show':
            case 'delete':
            case 'toggle':
                $objDocs = $this->Database->prepare("SELECT pid FROM tl_timeline_item WHERE id=?")
                    ->limit(1)
                    ->execute($id);

                if ($objDocs->numRows < 1) {
                    throw new \CoreBundle\Exception\AccessDeniedException('Invalid timeline item ID ' . $id . '.');
                }

                if (!in_array($objDocs->pid, $root)) {
                    throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to ' . \Input::get('act') . ' timeline item ID ' . $id . ' of timeline ID ' . $objDocs->pid . '.');
                }
                break;

            case 'editAll':
            case 'deleteAll':
            case 'overrideAll':
            case 'cutAll':
            case 'copyAll':
                if (!in_array($id, $root)) {
                    throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to access timeline ID ' . $id . '.');
                }

                $objDocs = $this->Database->prepare("SELECT id FROM tl_timeline_item WHERE pid=?")
                    ->execute($id);

                /** @var Symfony\Component\HttpFoundation\Session\SessionInterface $objSession */
                $objSession = \System::getContainer()->get('session');

                $session = $objSession->all();
                $session['CURRENT']['IDS'] = array_intersect((array)$session['CURRENT']['IDS'], $objDocs->fetchEach('id'));
                $objSession->replace($session);
                break;

            default:
                if (strlen(\Input::get('act'))) {
                    throw new \CoreBundle\Exception\AccessDeniedException('Invalid command "' . \Input::get('act') . '".');
                }

                if (!in_array($id, $root)) {
                    throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to access timeline ID ' . $id . '.');
                }
                break;
        }
    }


    /**
     * Add the type of input field
     *
     * @param array $arrRow
     *
     * @return string
     */
    public function listTitles($arrRow)
    {
        $key = $arrRow['published'] ? 'published' : 'unpublished';
        $date = \Date::parse(\Config::get('datimFormat'), $arrRow['tstamp']);

        $itemTypes = \Dmkzwo\ContaoTimelineBundle\Model\TimelineItemModel::getItemTypes();

        $rowClass = (floor($this->rowNumber / 12) % 2) ? 'even' : '';
        $this->rowNumber++;
        return "<span class=\"itemtype itemtype--".$arrRow['itemType']." " . $rowClass . "\"><span>" . $itemTypes[$arrRow['itemType']] . "</span></span> " . $arrRow['title'] . "\n";
//		return '
//<div class="cte_type ' . $key . '">' . $date . '</div>
//<div class="limit_height' . (!\Config::get('doNotCollapse') ? ' h40' : '') . '">
//<h2>' . $arrRow['question'] . '</h2>
//' . \StringUtil::insertTagToSrc($arrRow['answer']) . '
//</div>' . "\n";
    }

    /**
     * Return the "toggle visibility" button
     *
     * @param array $row
     * @param string $href
     * @param string $label
     * @param string $title
     * @param string $icon
     * @param string $attributes
     *
     * @return string
     */
    public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (\Input::get('tid')) {
            $this->toggleVisibility(\Input::get('tid'), (\Input::get('state') == 1), (@func_get_arg(12) ?: null));
            $this->redirect($this->getReferer());
        }

        // Check permissions AFTER checking the tid, so hacking attempts are logged
        if (!$this->User->hasAccess('tl_timeline_item::published', 'alexf')) {
            return '';
        }

        $href .= '&amp;tid=' . $row['id'] . '&amp;state=' . ($row['published'] ? '' : 1);

        if (!$row['published']) {
            $icon = 'invisible.svg';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . \StringUtil::specialchars($title) . '"' . $attributes . '>' . \Image::getHtml($icon, $label, 'data-state="' . ($row['published'] ? 1 : 0) . '"') . '</a> ';
    }

    /**
     * Disable/enable a user group
     *
     * @param integer $intId
     * @param boolean $blnVisible
     * @param \DataContainer $dc
     *
     * @throws \CoreBundle\Exception\AccessDeniedException
     */
    public function toggleVisibility($intId, $blnVisible, \DataContainer $dc = null)
    {
        // Set the ID and action
        \Input::setGet('id', $intId);
        \Input::setGet('act', 'toggle');

        if ($dc) {
            $dc->id = $intId; // see #8043
        }

        // Trigger the onload_callback
        if (is_array($GLOBALS['TL_DCA']['tl_timeline_item']['config']['onload_callback'])) {
            foreach ($GLOBALS['TL_DCA']['tl_timeline_item']['config']['onload_callback'] as $callback) {
                if (is_array($callback)) {
                    $this->import($callback[0]);
                    $this->{$callback[0]}->{$callback[1]}($dc);
                } elseif (is_callable($callback)) {
                    $callback($dc);
                }
            }
        }

        // Check the field access
        if (!$this->User->hasAccess('tl_timeline_item::published', 'alexf')) {
            throw new \CoreBundle\Exception\AccessDeniedException('Not enough permissions to publish/unpublish timeline item ID ' . $intId . '.');
        }

        // Set the current record
        if ($dc) {
            $objRow = $this->Database->prepare("SELECT * FROM tl_timeline_item WHERE id=?")
                ->limit(1)
                ->execute($intId);

            if ($objRow->numRows) {
                $dc->activeRecord = $objRow;
            }
        }

        $objVersions = new \Versions('tl_timeline_item', $intId);
        $objVersions->initialize();

        // Trigger the save_callback
        if (is_array($GLOBALS['TL_DCA']['tl_timeline_item']['fields']['published']['save_callback'])) {
            foreach ($GLOBALS['TL_DCA']['tl_timeline_item']['fields']['published']['save_callback'] as $callback) {
                if (is_array($callback)) {
                    $this->import($callback[0]);
                    $blnVisible = $this->{$callback[0]}->{$callback[1]}($blnVisible, $dc);
                } elseif (is_callable($callback)) {
                    $blnVisible = $callback($blnVisible, $dc);
                }
            }
        }

        $time = time();

        // Update the database
        $this->Database->prepare("UPDATE tl_timeline_item SET tstamp=$time, published='" . ($blnVisible ? '1' : '') . "' WHERE id=?")
            ->execute($intId);

        if ($dc) {
            $dc->activeRecord->tstamp = $time;
            $dc->activeRecord->published = ($blnVisible ? '1' : '');
        }

        // Trigger the onsubmit_callback
        if (is_array($GLOBALS['TL_DCA']['tl_timeline_item']['config']['onsubmit_callback'])) {
            foreach ($GLOBALS['TL_DCA']['tl_timeline_item']['config']['onsubmit_callback'] as $callback) {
                if (is_array($callback)) {
                    $this->import($callback[0]);
                    $this->{$callback[0]}->{$callback[1]}($dc);
                } elseif (is_callable($callback)) {
                    $callback($dc);
                }
            }
        }

        $objVersions->create();
    }
}
