<?php

namespace Dmkzwo\ContaoTeaserBundle\Classes;

use Symfony\Component\Yaml\Yaml;

class TeaserDCA extends \Backend
{

    public function getKeycolorBackendOptions() {
        $keycolorDefinitionFile = TL_ROOT . '/config/teaser_keycolors.yml';

        if (file_exists($keycolorDefinitionFile)) {
            $values = Yaml::parseFile(TL_ROOT . '/config/teaser_keycolors.yml');

            if (is_array($values ) && array_key_exists('keycolors', $values) && sizeof($values['keycolors'])) {
                return $values['keycolors'];
            }
        }

        return ['standard' => 'Standard'];

    }

    public static function isAllowedMultipleLinks($type) {
        return in_array($type, ['standard', 'tab', 'box2']);
    }

}
