<?php

namespace Dmkzwo\ContaoTeaserBundle\Elements;


use Dmkzwo\ContaoDzSubtypeBundle\Model\SubtypeModel;

class ContentTeaser extends \ContentElement
{

    protected $strTemplate = 'ce_dzteaser';

    public function generate()
    {
        $themeFolder = \System::getContainer()->getParameter('theme_folder');

        if (TL_MODE == 'FE') {
            $templateName = 'ce_dzteaser_' . $this->dzSubtype;
            $templateFile = sprintf(TL_ROOT . '/templates/%s/%s.html5', $themeFolder, $templateName);

            if (file_exists($templateFile)) {
                $this->strTemplate = $templateName;
            }
        }

        return parent::generate();
    }

    protected function compile()
    {
        $this->text = \StringUtil::toHtml5($this->dzTeaserText);

        // Add the static files URL to images
        if ($staticUrl = \System::getContainer()->get('contao.assets.files_context')->getStaticUrl()) {
            $path = \Config::get('uploadPath') . '/';
            $this->text = str_replace(' src="' . $path, ' src="' . $staticUrl . $path, $this->text);
        }
        $this->Template->text = \StringUtil::encodeEmail($this->text);
        $this->Template->addImage = false;

        if ($this->addDzTeaserImage && $this->singleSRC != '') {
            $objModel = \FilesModel::findByUuid($this->singleSRC);
            if ($objModel !== null && is_file(\System::getContainer()->getParameter('kernel.project_dir') . '/' . $objModel->path)) {
                $this->singleSRC = $objModel->path;
                $this->addImageToTemplate($this->Template, $this->arrData, null, null, $objModel);
            }
        }

        // Process Links

        if (0 === strncmp($this->url, 'mailto:', 7)) {
            $this->url = \StringUtil::encodeEmail($this->url);
        } else {
            $this->url = ampersand($this->url);
        }

        if ($this->linkTitle == '') {
            $this->linkTitle = $this->url;
        }


        $this->Template->href = $this->url;
        $this->Template->link = $this->linkTitle;
        $this->Template->target = '';
        $this->Template->rel = '';

        if ($this->titleText)
        {
            $this->Template->linkTitle = StringUtil::specialchars($this->titleText);
        }

        // Override the link target
        if ($this->target) {
            $this->Template->target = ' target="_blank"';
            $this->Template->rel = ' rel="noreferrer noopener"';
        }

        if (TL_MODE == 'BE') {
            $this->Template->title = '';
            $this->Template->linkTitle = '';
        }

        $this->Template->baseCssClass = 'ce_dzteaser';

        $keycolor = !empty($this->dzGeneralKeycolor) ? $this->dzGeneralKeycolor : 'standard';
//        $keycolor = !empty($this->dzTeaserKeycolor) ? $this->dzTeaserKeycolor : 'standard';


        $this->Template->keycolorClass = $this->Template->baseCssClass . '--keycolor-' . $keycolor;

    }
}

class_alias(ContentTeaser::class, 'ContentDzTeaser');
