<?php

namespace Dmkzwo\ContaoTeaserBundle\Classes;

use Symfony\Component\Yaml\Yaml;

class TeaserDCA extends \Backend
{

    public function getTeaserSubtypeBackendOptions()
    {
        $options = [
            'standard' => 'Standard-Teaser',
            'standard dzteaser--centered' => 'Standard-Teaser (vertikal mittig)',
            'box' => 'Box-Teaser (Einfachlink)',
            'box2' => 'Box-Teaser (Mehrfachlink)',
            'round-image' => 'Teaser mit rundem Bild',
            'quote' => 'Zitat-Teaser',
            'icon' => 'Icon-Teaser',
            'hint' => 'Hinweis-Teaser',
            'tab' => 'Tab-Teaser',
        ];

        return $options;
    }

    public function getKeycolorBackendOptions() {
        $keycolorDefinitionFile = TL_ROOT . '/config/teaser_keycolors.yml';

        if (file_exists($keycolorDefinitionFile)) {
            $values = Yaml::parseFile(TL_ROOT . '/config/teaser_keycolors.yml');

            if (is_array($values ) && array_key_exists('keycolors', $values) && sizeof($values['keycolors'])) {
                return $values['keycolors'];
            }
        }

        return ['standard' => 'Standard'];

    }

    public static function isAllowedMultipleLinks($type) {
        return in_array($type, ['standard', 'tab', 'box2']);
    }

}
