<?php

namespace Dmkzwo\ContaoTabsBundle\Elements;


class ContentTabsBegin extends \ContentElement
{

    protected $strTemplate = 'ce_dztabs_begin';

    public function generate()
    {
        if (file_exists(TL_ROOT . '/templates/ww_theme/ce_dztabs_begin_' . $this->dzSubtype . '.html5')) {
            $this->strTemplate = 'ce_dztabs_begin_' . $this->dzSubtype;
        }

        return parent::generate();
    }

    protected function compile()
    {

        $arrTabs = \StringUtil::deserialize($this->dzTabs);

        if (TL_MODE == 'BE') {

            $beTitle = '';

            if (!empty($arrTabs)) {
                $counter = 1;

                foreach ($arrTabs as $tab) {
                    $beTitle .= $counter++ . '. ' . $tab['tab_name'] . '<br>';
                }
            }

            $this->Template = new \BackendTemplate('be_wildcard');
            $this->Template->wildcard = '### TABS: CONTAINER BEGIN ###';
            $this->Template->title = $beTitle;

        } else {

            $arrTabNewlines = [];

            if (!empty($arrTabs)) {
                $default = 0;

                foreach ($arrTabs as $index => $tab) {
                    $arrTabTitles[] = $tab['tab_name'];

//                    if ($title['tab_tabs_default']) {
//                        $default = $index;
//                    }

                    $arrTabNewlines[] = $tab['tab_newline'];
                }

//                if ($defaultByCookie != '') {
//                    $this->Template->tab_tabs_default = $defaultByCookie;
//                } else {
//                    $this->Template->tab_tabs_default = $default;
//                }

                $this->Template->titles = $arrTabTitles;
                $this->Template->newlines = $arrTabNewlines;
            }

        }

    }
}

class_alias(ContentTabsBegin::class, 'ContentDzTabsBegin');
