# Contao Bundle: Tabs

## Prerequisites

**Stimulus**

```
yarn add stimulus --dev
```

## Installation

```
composer require dmkzwo/contao-tabs-bundle
```

## Webpack Integration

see https://stimulus.hotwired.dev/handbook/installing

### with register

```
import { Application } from "stimulus"
import TabsController from "../web/bundles/contaotabs/controllers/tabs_controller"

const application = Application.start()
application.register("tabs", TabsController)
```

### with require.context and symlinks

```
// use stimulus
import { Application } from "stimulus"
import { definitionsFromContext } from "stimulus/webpack-helpers"

const application = Application.start()
const context = require.context("./js/controllers", true, /\.js$/)
application.load(definitionsFromContext(context))
```

add symlink

```
mkdir -p theme_src/js/controllers
cd theme_src/js/controllers
ln -s ../../../web/bundles/contaotabs/controllers/tabs_controller.js tabs_controller.js
```

## Stylesheets

minimum required scss:

```
.ce_dztabs__pane {
    &.is-hidden {
        display: none;
    }
}
```
