// import {sliderSettings, standardSliderSettings, addSliderSettings} from "Settings/slider-settings";

$(function () {
    let hash = window.location.hash.replace('#', '');

    // Find all tab groups
    let tabGroups = $('.ce_dztabs');

    // Process each tab group
    tabGroups.each((groupIndex, tabGroup) => {

        let isFullWidth = $(tabGroup).hasClass('ce_tabcontrol--full-width');
        let isClosed = $(tabGroup).hasClass('ce_dztabs--closed');
        let isHash = $(tabGroup).hasClass('ce_dztabs--hash');

        if (isFullWidth && !isClosed) {
            $(tabGroup).addClass('active');
        }

        // Extract config
        let config = {
            closed: $(tabGroup).hasClass('ce_dztabs--closed'),
        };

        let activePane = $(tabGroup).data('active');
        if (!activePane) {
            activePane = 0;
        }


        // Find active index
        let activeIndex = 0;
        if (isHash) {
            activeIndex = -1;
        }

        log.debug(activeIndex);

        let tempPanes = $('.ce_dztabs__pane', tabGroup);
        tempPanes.each((paneIndex, pane) => {
            let cssClass = $(pane).attr('class');
            if (cssClass.indexOf(' ' + hash + ' ') !== -1) {
                activeIndex = paneIndex;
                config.closed = false;
            }
        });

        // Process all tabs
        let tabs = $('.nav-link', tabGroup);
        tabs.each((tabIndex, tab) => {
            $(tab).attr('id', 'tab_' + groupIndex + '_' + tabIndex);
            $(tab).attr('href', '#tab_pane_' + groupIndex + '_' + tabIndex);
            $(tab).attr('aria-controls', 'tab_pane_' + groupIndex + '_' + tabIndex);

            // if (tabIndex == activePane && !config.closed) {
            if (tabIndex == activeIndex) {
                $(tab).addClass('active');
            }
        });
        // Process all panes
        let panes = $('.ce_dztabs__pane', tabGroup);
        panes.each((paneIndex, pane) => {
            $(pane)
                .attr('id', 'tab_pane_' + groupIndex + '_' + paneIndex)
                .attr('aria-labelledby', 'tab_' + groupIndex + '_' + paneIndex);
            // if (paneIndex == activePane && !config.closed) {
            if (paneIndex == activeIndex) {
                $(pane).addClass('active');
            }
        });

        // Add "close again on second click (if is active)"
        // $(tabGroup).click(evt => {
        //     let target = $(evt.target);
        //     let activeTab = target.closest('.nav-link.active');

        $(tabGroup).find('.nav-link').click(evt => {
            let target = $(evt.currentTarget);
            // let activeTab = target.closest('.nav-link.active');

            let activeTab = false;
            if (target.hasClass('active')) {
                activeTab = target;
            }

            if (isFullWidth && isClosed) {
                $(tabGroup).addClass('active');
            }

            if (activeTab.length && !isFullWidth) {
                // Remove active class from tab
                activeTab.removeClass('active');
                // Remove active class from related pane
                let paneId = activeTab.attr('href');
                $(paneId).removeClass('active');
                // Stop propagation
                evt.stopPropagation();
                evt.preventDefault();

            } else {
                // let activePaneId = target.closest('.nav-link').attr('href');
                let activePaneId = target.attr('href');
                log.debug(activePaneId);

                // reinitSliders(activePaneId);
                $(document).trigger('tab:recreate', [activePaneId]);
            }
        });

        // $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        //     log.debug('tab shown');
        //     e.target // newly activated tab
        //     e.relatedTarget // previous active tab
        // })
    });
});

// function reinitSliders(activePaneId) {
//
//     for (var selector in standardSliderSettings) {
//         // log.debug('reinit' + selector);
//
//         if ($(activePaneId).find(selector).length > 0) {
//
//             let $slider = $(activePaneId).find('.ce_sliderStart');
//
//             let actSliderSettings = standardSliderSettings[selector];
//             actSliderSettings = addSliderSettings($slider, actSliderSettings);
//
//             let $sliderWrapper = $(activePaneId).find('.slider-wrapper');
//
//             $sliderWrapper.slick('unslick');
//
//             $sliderWrapper.slick(
//                 actSliderSettings
//             );
//         }
//     }
//
//     for (var selector in sliderSettings) {
//         // log.debug('reinit' + selector);
//
//         if ($(activePaneId).find(selector).length > 0) {
//
//             let $slider = $(activePaneId).find(selector);
//
//             let actSliderSettings = sliderSettings[selector];
//
//             $slider.slick('unslick');
//
//             $slider.slick(
//                 actSliderSettings
//             );
//         }
//     }
//
// }
//
