$(function () {
    // extract hash from url
    let hash = window.location.hash.replace('#', '');

    // Find all tab groups
    let tabGroups = $('.ce_dztabs');

    // Process each tab group
    tabGroups.each(function (groupIndex, tabGroup) {

        let isFullWidth = $(tabGroup).hasClass('ce_tabcontrol--full-width');
        let isInitiallyClosed = $(tabGroup).hasClass('ce_dztabs--closed');
        let isHash = $(tabGroup).hasClass('ce_dztabs--hash');

        if (!isInitiallyClosed) {
            $(tabGroup).addClass('active');
        }

        // Find active index
        let activeIndex = 0;
        if (isHash) {
            activeIndex = -1;
        }

        log.debug(activeIndex);
        log.debug('isInitiallyClosed', isInitiallyClosed);


        // open tab if url hash correspond with custom style class name (set in contao backend)
        // http(s)://.../page.html#specialtab <-> class="... specialtab ..."
        $('.ce_dztabs__pane', tabGroup).each(function (paneIndex, pane) {
            let cssClass = $(pane).attr('class');
            if (cssClass.indexOf(' ' + hash + ' ') !== -1) {
                activeIndex = paneIndex;
            }
        });

        // Set attributes for tab navigation
        $('.nav-link', tabGroup).each(function (tabIndex, tab) {
            $(tab).attr('id', 'tab_' + groupIndex + '_' + tabIndex);
            $(tab).attr('href', '#tab_pane_' + groupIndex + '_' + tabIndex);
            $(tab).attr('aria-controls', 'tab_pane_' + groupIndex + '_' + tabIndex);

            if (!isInitiallyClosed && (tabIndex === activeIndex)) {
                $(tab).addClass('active');
            }
        });

        // Set attributes for tab panes
        $('.ce_dztabs__pane', tabGroup).each(function (paneIndex, pane) {
            var relatedTabLabel = $('#tab_' + groupIndex + '_' + paneIndex + ' .label').html();

            $(pane)
                .attr('id', 'tab_pane_' + groupIndex + '_' + paneIndex)
                .attr('aria-labelledby', 'tab_' + groupIndex + '_' + paneIndex);
            $(pane).prepend('<h3 aria-hidden="true" class="only-print">' + relatedTabLabel + '</h3>')

            if (!isInitiallyClosed && (paneIndex === activeIndex)) {
                $(pane).addClass('active');
            }
        });

        $(tabGroup).find('.nav-link').click(function (evt) {
            let clickedTab = $(evt.currentTarget);
            let clickedTabActive = clickedTab.hasClass('active');

            if (isInitiallyClosed) {
                $(tabGroup).addClass('active');
            }

            // if (clickedTabActive && !isFullWidth) {
            if (clickedTabActive) {
                if (isInitiallyClosed) {
                    // Remove active class from tab
                    clickedTab.removeClass('active');
                    // Remove active class from related pane
                    $(clickedTab.attr('href')).removeClass('active');
                    // Stop propagation
                    evt.stopPropagation();
                    evt.preventDefault();
                }
            } else {
                let activePaneId = clickedTab.attr('href');
                log.debug(activePaneId);

                // reinitSliders(activePaneId);
                $(document).trigger('tab:recreate', [activePaneId]);
            }
        });

    });
});

