# Contao Bundle: Subtype management

Diese Erweiterung erlaubt die individuelle/redaktionelle Vergabe von Subtypes für Artikel und ausgewählte Content-Elemente.
Dazu werden die im Backend vorgenommenen Einstellungen als CSS-Klassen zur Frontentausgabe hinzugefügt. Die Interpretation dieser CSS-Klassen ist frei wählbar.

## Installation

Satis-Repository zu composer.json hinzufügen:

```
"repositories": [
{
"type": "composer",
"url": "https://satis.dmkzwo-service.de"
},
...
]
```

Installation per composer:

```
composer require dmkwzo/contao-subtype-bundle
```


## Subtype-Einstellungen für Artikel

Die für Artikel zur Verfügung stehenden Subtypes werden im Backend unter *SUBTYPE-KONFIGURATION / Subtypes (Artikel)* verwaltet.

Jeder Eintrag hat die folgenden Felder:

| Feld |  |
|---|---|
| Name | für Ausgabe im Auswahl-Dropdown |
| Eindeutiger Bezeichner | zur Verwendung in Inserttags |
| Style-Klassen | ein oder mehrere Style-Klassen, die zur Frontendausgabe hinzugefügt werden |


## Subtype-Einstellungen für Content-Elemente

Die für Content-Elemente zur Verfügung stehenden Subtypes werden im Backend unter *SUBTYPE-KONFIGURATION / Subtypes (CEs)* verwaltet.

Jeder Eintrag hat die folgenden Felder:

| Feld |  |
|---|---|
| Name | für Ausgabe im Auswahl-Dropdown |
| Eindeutiger Bezeichner | zur Verwendung in Inserttags |
| verfügbar für CE | hier wird festgelegt, für welches Content-Element dieser Subtype zur Verfügung stehen sollen; der Inhalt dieser Liste wird unter *Einstellungen* verwaltet (s.u.) |
| Style-Klassen | ein oder mehrere Style-Klassen, die zur Frontendausgabe hinzugefügt werden |


## Template anpassen

### Artikel

* Template *mod_article.html5* überschreiben (falls noch nicht vorhanden)
  ```
  cp vendor/contao/core-bundle/src/Resources/contao/templates/modules/mod_article.html5 TEMPLATEDIR/
  ```

* Folgende Anweisung am Kopf von *mod_article.html5* hinzufügen:
  ```
  <?php
  \Dmkzwo\ContaoSubtypeBundle\Library\SubtypeHelper::addStylesToTemplate($this);
  ?>
  ```

### Content-Elemente

* Template *block_searchable.html5* überschreiben (falls noch nicht vorhanden)
  ```
  cp vendor/contao/core-bundle/src/Resources/contao/templates/block/block_searchable.html5 TEMPLATEDIR/
  ```

* Folgende Anweisung am Kopf von *block_searchable.html5* hinzufügen:
  ```
  <?php
  \Dmkzwo\ContaoSubtypeBundle\Library\SubtypeHelper::addStylesToTemplate($this);
  ?>
  ```


## Einstellungen

Unter *System/Einstellungen/Subtype-Einstellungen* festlegen, für welche Content-Elemente ein Subtype-Auswahl möglich sein soll.


## Inserttags

### {{subtype_class::*}}

Parameter: Eindeutiger Bezeichner eines CEs (siehe Admin) \
Ausgabe: zugehörige Style-Klasse(n)

### {{arttype_class::*}}

Parameter: Eindeutiger Bezeichner eines Artikels (siehe Admin) \
Ausgabe: zugehörige Style-Klasse(n)
