<?php


namespace Dmkzwo\ContaoSubtypeBundle\Library;


use Dmkzwo\ContaoSubtypeBundle\Classes\SubtypeDCA;
use Dmkzwo\ContaoSubtypeBundle\Model\ArttypeModel;
use Dmkzwo\ContaoSubtypeBundle\Model\SubtypeModel;


class SubtypeHelper
{

    public static function getSubtypesForCe($dc)
    {

        $type = $dc->activeRecord->type;

        // Hack (TODO)
        if (strpos($type, 'tabcontrol') !== false) {
            $type = 'tabcontroltab';
        }

        $subtypes = SubtypeModel::findBy('target', $type);

        //echo $dc->activeRecord->type;
        //var_dump($subtypes);

        $options = [];

        $options['standard'] = 'Standard';

        if ($subtypes) {
            foreach ($subtypes as $subtype) {
                $options[$subtype->uniquekey] = $subtype->name;
            }
        }

        return $options;

    }

    public static function getSubtypesForArticle($dc)
    {

        $subtypes = ArttypeModel::findAll();

        $options = [];

        $options['standard'] = 'Standard';

        if ($subtypes) {
            foreach ($subtypes as $subtype) {
                $options[$subtype->uniquekey] = $subtype->name;
            }
        }

        return $options;

    }

    public function myReplaceInsertTags($strTag)
    {
        $arrSplit = explode('::', $strTag);

        if ($arrSplit[0] == 'subtype_class') {
            if (!$arrSplit[1]) {
                return '';
            }

            $subtypeKey = $arrSplit[1];

            if ($subtypeKey != 'standard') {
                $subtypeObj = SubtypeModel::findOneBy('uniquekey', $subtypeKey);
                if ($subtypeObj) {
                    return $subtypeObj->styleClass;
                }
            }

            return 'standard';
        }

        if ($arrSplit[0] == 'arttype_class') {
            if (!$arrSplit[1]) {
                return '';
            }

            $arttypeKey = $arrSplit[1];

            if ($arttypeKey != 'standard') {
                $arttypeObj = ArttypeModel::findOneBy('uniquekey', $arttypeKey);
                if ($arttypeObj) {
                    return $arttypeObj->styleClass;
                }
            } else {
                return 'mod_article--bg-standard';
            }

            return 'standard';
        }

        return false; // this is important!!!

    }

    public static function getAllContentElementTypes()
    {
        \Controller::loadDataContainer('tl_content');
        \System::loadLanguageFile('tl_content');

        $blacklist = [
            '__selector__',
            'default',
        ];

        $allTypeKeys = array_keys($GLOBALS['TL_DCA']['tl_content']['palettes']);
        $types = [];

        foreach ($allTypeKeys as $key) {
            if (in_array($key, $blacklist)) {
                continue;
            }

            $types[$key] = $GLOBALS['TL_LANG']['CTE'][$key][0] . ' ['.$key.']';
        }

        return $types;
    }

//    public function addSubtypeStyleClass($buffer, $templateName)
//    {
//
//        $templateNames = SubtypeDCA::getTemplatesNames();
//        var_dump($templateNames);
//
//        if (in_array($templateName, $templateNames)) {
//
//            $buffer = str_replace('class="' . $templateName, 'class="' . $templateName . ' ', $buffer);
//
//        }
//
//        return $buffer;
//    }

}
