<?php

$GLOBALS['TL_DCA']['tl_dz_subtype'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'enableVersioning' => true,
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
                'uniquekey' => 'unique'
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 1,
            'fields' => array('target', 'name'),
            'flag' => 11,
            'panelLayout' => 'filter;search,limit',
            'disableGrouping' => true,
        ),

        'label' => array
        (
            'fields' => array('name', 'uniquekey'),
            'format' => '<strong>%s</strong> <span style="color:grey">[Key: %s]</span>',
            'label_callback' => array('\\Dmkzwo\\ContaoSubtypeBundle\\Classes\\SubtypeDCA', 'listLabelCallback'),
        ),

        'global_operations' => array
        (
            'all' => array
            (
                // 'label'               => &$GLOBALS['TL_LANG']['MSC']['all'],
                'href' => 'act=select',
                'class' => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset()" accesskey="e"'
            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                //'label'               => &$GLOBALS['TL_LANG']['MSC']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.svg'
            ),
            'copy' => array
            (
                //'label'               => &$GLOBALS['TL_LANG']['MSC']['copy'],
                'href' => 'act=copy',
                'icon' => 'copy.gif'
            ),
            /*
                  'cut' => array
                  (
                      'label'               => &$GLOBALS['TL_LANG']['MSC']['cut'],
                      'href'                => 'act=paste&amp;mode=cut',
                      'icon'                => 'cut.gif'
                  ),
            */
            'delete' => array
            (
                // 'label'               => &$GLOBALS['TL_LANG']['MSC']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.svg',
                'attributes' => 'onclick="if(!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\'))return false;Backend.getScrollOffset()"'
            ),
            'show' => array
            (
                // 'label'               => &$GLOBALS['TL_LANG']['MSC']['show'],
                'href' => 'act=show',
                'icon' => 'show.svg'
            )
        )
    ),

    // Palettes
    'palettes' => array
    (
        'default' => 'name,uniquekey,target,styleClass;'
    ),


    // Fields
    'fields' => array
    (

        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment"
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),

        'name' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_dz_subtype']['name'],
            'search' => true,
            'sorting' => true,
            'flag' => 1,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),

        'uniquekey' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_dz_subtype']['uniquekey'],
            'search' => true,
            'sorting' => true,
            'flag' => 1,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50', 'doNotCopy' => true),
            'sql' => "varchar(255) NOT NULL default ''"
        ),

        'target' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_dz_subtype']['target'],
            'search' => true,
            'sorting' => true,
            'flag' => 1,
            'inputType' => 'select',
            'options_callback' => array('\\Dmkzwo\\ContaoSubtypeBundle\\Classes\\SubtypeDCA', 'getCeOptions'),
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),

        'styleClass' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_dz_subtype']['styleClass'],
            'search' => true,
            'sorting' => true,
            'flag' => 1,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 255, 'tl_class' => 'clr long'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),

    )
);


class tl_dz_subtype extends \Backend
{


}

