<?php

namespace Dmkzwo\ContaoSubtypeBundle\Classes;


class SubtypeDCA extends \Backend
{

    public function getCeOptions()
    {
        $options = [
            'headline' => 'Überschrift',
            'text' => 'Text',
            'list' => 'Aufzählung',
            'table' => 'Tabelle',
            'hyperlink' => 'Link',
            'image' => 'Bild',
            //'tabcontroltab' => 'Tabs (alt)',
            'sliderStart' => 'Slider',
            'accordionStart' => 'Akkordeon',

            'dzteaser' => 'Teaser',
            'dztabsbegin' => 'Tabs',
            'dzyoutube' => 'Youtube (Modal)',
            'dztile' => 'Kachel'
        ];

        return $options;
    }

    public static function getDcaCeOptions()
    {
        $options = [
            'headline',
            'text',
            'list',
            'table',
            'hyperlink',
            'image',
            //'tabcontroltab',
            'sliderStart',
            'accordionStart',
            'dztabsbegin',
            'dzyoutube',
            'dztile',
        ];

        return $options;
    }

    public static function getTemplatesNames() {
        $templateKeys = array_keys(self::getCeOptions());

        foreach ($templateKeys as &$templateKey) {
            $templateKey = 'ce_' . $templateKey;
        }

        return $templateKeys;
    }

    public function listLabelCallback($row, $label, $dc) {
        $ceOptions = $this->getCeOptions();
        return $ceOptions[$row['target']] . ': ' . $label;
    }

    public function adjustSubtype($value, $dc) {
        echo 'value: ' . $value;
        echo 'type: ' . $dc->activeRecord->type;
        echo 'subtype: ' . $dc->activeRecord->dzSubtype;

        return $value;
    }

}
