<?php

declare(strict_types=1);

namespace Dmkzwo\ContaoStageBundle\EventListener;

use Contao\CoreBundle\DependencyInjection\Attribute\AsHook;
use Contao\LayoutModel;
use Contao\PageModel;
use Contao\PageRegular;

#[AsHook('generatePage')]
class GeneratePageListener
{
    public function __invoke(PageModel $pageModel, LayoutModel $layout, PageRegular $pageRegular): void
    {
        if ($pageModel->cssClass) {
            $pageModel->cssClass .= ' '.$pageModel->stageBgColor;
        } else {
            $pageModel->cssClass = $pageModel->stageBgColor;
        }

        if ($pageModel->stageSrc) {
            $pageModel->cssClass .= ' with-stage-image';
        }
    }
}
