<?php

declare(strict_types=1);

namespace Dmkzwo\ContaoStageBundle\Controller\FrontendModule;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\DependencyInjection\Attribute\AsFrontendModule;
use Contao\CoreBundle\Image\Studio\Studio;
use Contao\FilesModel;
use Contao\ModuleModel;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

#[AsFrontendModule(category: 'miscellaneous')]
class StageModuleController extends AbstractFrontendModuleController
{
    private Studio $studio;

    public function __construct(Studio $studio)
    {
        $this->studio = $studio;
    }

    protected function getResponse(Template $template, ModuleModel $model, Request $request): Response
    {
        // Todo: DOC
        $page = $this->getPageModel();

        $headline = '';

        if ($page->useTitleAsHeadline) {
            // headline
            if (strlen(trim($page->altHeadline))) {
                $headline = $page->altHeadline;
            } else {
                $headline = $page->title;
            }

            // subline
            if (strlen(trim($page->subline))) {
                $headline .= sprintf('<span>%s</span>', $page->subline);
            }

            // image
            $template->stageSrc = $page->stageSrc;
            $template->stageImageSize = 1;

            // TODO: remove this hack
            $imageSize = 16;
            if (str_contains($template->getName(), 'styleguide')) {
                $imageSize = 23;
            }

            $stageImage = $this->getStageFigure($page->stageSrc, $imageSize);

            if ($stageImage) {
                $template->stageImage = $this->getStageFigure($page->stageSrc, $imageSize);

                $file = FilesModel::findByUuid($template->stageImage->getMetadata()->getUuid());


                $template->stageCopyright = $file &&  strlen(trim($file->dzCopyright)) ? $file->dzCopyright : '';
            }

//            if ($file) {

//            }

//            $objFile = FilesModel::findByUuid($page->stageSrc);
//
//            if ($objFile) {
//                $this->output['downloadUrl'] = $objFile->path;
//            }
        }



        $template->headline = $headline;
        $template->showStage = $page->useTitleAsHeadline;

        return $template->getResponse();
    }

    protected function getStageFigure($imageSrc, int $imageSize)
    {
        $figureBuilder = $this->studio->createFigureBuilder();

        if ($imageSrc) {
            $figureBuilder
                ->fromUuid($imageSrc)
                ->setSize($imageSize);

            $figureBuilder->setSize($imageSize);

            return $figureBuilder->build();
        }

        return false;


//        dd($this->output['mediaFigure']);
    }
}
