<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Library;

use Dmkzwo\ContaoSocialmediaBundle\Classes\TwitterApi;
use Dmkzwo\ContaoSocialmediaBundle\Model\TwitterAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\TwitterPostModel;


class TwitterUpdater extends AbstractAccountUpdater
{
    public function __construct($account, $config)
    {
        parent::__construct($account, $config);

        $this->api = new TwitterApi($account);

        $this->apiClass = 'Dmkzwo\ContaoSocialmediaBundle\Classes\TwitterApi';
        $this->postModelClass = 'Dmkzwo\ContaoSocialmediaBundle\Model\TwitterPostModel';
    }

//    protected function createOrUpdatePost($post) {
////        echo '<pre>';
////        var_dump($post);
////        echo '</pre>';
////        echo '<br><br>';
////        return;
//
//        $postId = TwitterApi::getId($post);
//
//        $postObj = TwitterPostModel::findOneBy('postId', $postId);
//
//        if ($postObj) {
//            $action = 'UPDATE';
//
//            $this->setUpdateData($post, $postObj);
//
//        } else {
//            $action = 'CREATE';
//
//            $postObj = new TwitterPostModel();
//
//            $this->setBaseData($post, $postObj);
//            $this->setUpdateData($post, $postObj);
//
//        }
//
//        try {
//            $postObj->save();
//        } catch (\Exception $e) {
//            echo $e->getMessage();
//        }
//
//        $this->saveImage($postId, $postObj);
////
//        $this->logPost($postObj, $action);
//
//    }

    protected function setUpdateData($post, &$postObj) {
        $postObj->postId = TwitterApi::getId($post);
        $postObj->tstamp = TwitterApi::getCreatedTime($post);

        $postObj->message = TwitterApi::getMessage($post);
        $postObj->permaLink = TwitterApi::getPermaLink($post, $this->account);
        $postObj->mediaUrl = TwitterApi::getPicture($post);
        $postObj->userName = TwitterApi::getUserName($post);
        $postObj->screenName = TwitterApi::getUserScreenName($post);
    }
}
