<?php


namespace Dmkzwo\ContaoSocialmediaBundle\Library;


class SocialmediaHelper
{

    public function myReplaceInsertTags($strTag) {
        $arrSplit = explode('::', $strTag);

        if ($arrSplit[0] == '[inserttagname]') {
            if (!$arrSplit[1]) {
                return '';
            }

            return '...';
        }

        return false; // this is important!!!

    }

    // TODO: replace this in 10j wall bundle with getInstagramImage
    public static function getMediaImage($userId, $mediaId) {
        $relMediaFile = \System::getContainer()->getParameter('instagram.social_media_dir') . DIRECTORY_SEPARATOR . $userId . DIRECTORY_SEPARATOR . $mediaId . '.jpg';
        $absMediaFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $relMediaFile;

        if (file_exists($absMediaFile) && is_file($absMediaFile)) {
            return $relMediaFile;
        }

        return false;
    }

    public static function getInstagramImage($userId, $mediaId) {
//        $relMediaFile = \System::getContainer()->getParameter('instagram.social_media_dir') . DIRECTORY_SEPARATOR . $userId . DIRECTORY_SEPARATOR . $mediaId . '.jpg';
        $relMediaFile = \System::getContainer()->getParameter('instagram.social_media_dir') . DIRECTORY_SEPARATOR . $mediaId . '.jpg';
        $absMediaFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $relMediaFile;

        if (file_exists($absMediaFile) && is_file($absMediaFile)) {
            return $relMediaFile;
        }

        return false;
    }

    public static function getFacebookImage($mediaId) {
        $relMediaFile = \System::getContainer()->getParameter('facebook.social_media_dir') . DIRECTORY_SEPARATOR . $mediaId . '.jpg';
        $absMediaFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $relMediaFile;

        if (file_exists($absMediaFile) && is_file($absMediaFile)) {
            return $relMediaFile;
        }

        return false;
    }

    public static function getFlickrImage($mediaId) {
        $relMediaFile = \System::getContainer()->getParameter('flickr.social_media_dir') . DIRECTORY_SEPARATOR . $mediaId . '.jpg';
        $absMediaFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $relMediaFile;

        if (file_exists($absMediaFile) && is_file($absMediaFile)) {
            return $relMediaFile;
        }

        return false;
    }

    public static function existImage($src) {
        $absMediaFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $src;

        if (file_exists($absMediaFile) && is_file($absMediaFile)) {
            return $src;
        }

        return false;
    }

    // TODO: replace with prepareInstagramHtml in 10j
    public static function prepareCaptionHtml($caption) {
        return self::prepareInstagramHtml($caption);
    }

    public static function prepareInstagramHtml($caption) {
        $caption .= ' ';
        $caption = preg_replace('/#(.+?)\s/', '<a href="https://www.instagram.com/explore/tags/${1}" target="_blank">#${1}</a> ', $caption);
        $caption = preg_replace('/@(.+?)\s/', '<a href="https://www.instagram.com/${1}" target="_blank">@${1}</a> ', $caption);
        $caption = str_replace("\n", '<br>', $caption);
        $caption = str_replace("?", '', $caption);

        return $caption;
    }

//    public static function prepareTimestamp($timestamp) {
//        $secondsSincePosted = time() - $timestamp;
//
//        if ($secondsSincePosted <= 120) {
//            return $GLOBALS['TL_LANG']['dz_socialmedia']['posted_now'];
//        } elseif ($secondsSincePosted <= 3600) {
//            return floor($secondsSincePosted/60) . ' ' . $GLOBALS['TL_LANG']['dz_socialmedia']['posted_minutes'];
//        } elseif ($secondsSincePosted <= 7200) {
//            return '1 ' . $GLOBALS['TL_LANG']['dz_socialmedia']['posted_hour'];
//        } elseif ($secondsSincePosted <= 24 * 3600) {
//            return floor($secondsSincePosted/3600) . ' ' . $GLOBALS['TL_LANG']['dz_socialmedia']['posted_hours'];
//        } elseif ($secondsSincePosted <= 48 * 3600) {
//            return $GLOBALS['TL_LANG']['dz_socialmedia']['posted_day'];
//        } elseif ($secondsSincePosted <= 7 * 24 * 3600) {
//            return floor($secondsSincePosted/(24 * 3600)) . ' ' . $GLOBALS['TL_LANG']['dz_socialmedia']['posted_days'];
//        } else {
//            return floor($secondsSincePosted/(7 * 24 * 3600)) . ' ' . $GLOBALS['TL_LANG']['dz_socialmedia']['posted_weeks'];
//        }
//    }

    public static function shortenText($text, $letterCount) {
        if (strlen($text) > $letterCount) {
            $lastSpace = strrpos(substr($text, 0, $letterCount), ' ');
            $shortenedText = substr($text, 0, $lastSpace);
            return $shortenedText.'...';
        } else {
            return $text;
        }
    }
}

