<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Library;


abstract class AbstractAccountUpdater
{
    protected $api;
    protected $account;
    protected $config;

    protected $accountId;
    protected $imageDir;


    public function __construct($account, $config)
    {
        $this->account = $account;
        $this->accountId = $account->id;
        $this->config = $config;
    }


    public function run() {
        $this->logRun();

        $this->prepareDirectories();
        $this->updatePosts($this->config['debug']);
    }

    protected function prepareDirectories() {
        $baseDir = \System::getContainer()->getParameter('dz.socialmedia.social_media_dir');
        if (!file_exists($baseDir)) {
            mkdir($baseDir, 0777, true);
        }
        if (!file_exists($baseDir . DIRECTORY_SEPARATOR . '.public')) {
            touch($baseDir . DIRECTORY_SEPARATOR . '.public');
        }

        $this->imageDir = \System::getContainer()->getParameter($this->config['accountType'] . '.social_media_dir');

        $directories = [
            $this->imageDir,
        ];

        foreach ($directories as $directory) {
            $dir = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $directory;
            if (!file_exists($dir)) {
                mkdir($dir, 0777, true);
            }
        }
    }

    protected function updatePosts($debug = false) {
        $posts = $this->api->getFeeds($debug);

        if (!isset($posts)) {
            return;
        }

        if (is_array($posts) && sizeof($posts)) {
            foreach ($posts as $post) {
                static::createOrUpdatePost($post);
            }
        }
//        var_dump($posts);
    }

    abstract protected function createOrUpdatePost($post);

    protected function setBaseData($post, &$postObj) {
        $postObj->pid = $this->accountId;
        $postObj->published = ($this->account->publishMode == 'blacklist') ? '1' : '';
        $postObj->hideOnWall = ($this->account->publishMode == 'blacklist') ? '' : '1';
        $postObj->accountId = $this->accountId;
    }

    abstract protected function setUpdateData($post, &$postObj);

    protected function saveImage($postId, $postObj) {
        $targetFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $this->imageDir . DIRECTORY_SEPARATOR . $postId . '.jpg';
        $relTargetFile = $this->imageDir . '/' . $postId . '.jpg';

        $sourceUrl = $postObj->mediaUrl;
        $sourceData = $this->file_get_contents_curl($sourceUrl);

        $writeStatus = file_put_contents($targetFile, $sourceData);

        if ($writeStatus) {
            $postObj->mediaSrc = $relTargetFile;
            $postObj->save();
        }
    }

    protected function file_get_contents_curl($url) {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);

        $data = curl_exec($ch);
        curl_close($ch);

        return $data;
    }

    protected function logRun() {
        if ($this->config['command']) {
            $entryStr = sprintf('%s - %s Feed: %s', date('d.m.Y H:i:s'), ucfirst($this->config['accountType']), $this->account->accountName);
            echo $entryStr . "\n";
        }
    }

    protected function logPost($postObj, $action) {
        if ($this->config['command'] && $this->config['output']) {
            $entryStr = sprintf('%s [%s] - %s / %s / %s', date('d.m.Y H:i:s'), $action, $this->account->accountName, $postObj->id, substr($postObj->message, 0, 40));
            echo $entryStr . "\n";
        }
    }
}
