<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Classes;

class YoutubeApi
{
    private $apiBaseUrl;
    private $youtubeApiKey;
    private $queryParam;

    protected $youtubeAccessDataFound = false;
    protected $twitterSession;

    /**
     * InstagramApi constructor.
     * @param $params
     */
    public function __construct($account)
    {
        $this->apiBaseUrl = \System::getContainer()->getParameter('youtube.api_base_url');
        $this->youtubeApiKey= $account->youtubeApiKey;
        $this->queryParam = $account->queryParam;

        if (strlen($this->youtubeApiKey) && ($this->queryParam)) {
            $this->youtubeAccessDataFound = true;

        } else {
            $this->youtubeAccessDataFound = false;
        }

    }

    public function getFeeds($debug = false) {

        $entries = [];

        $contentUrl = sprintf("%schannels?part=contentDetails&forUsername=%s&key=%s", $this->apiBaseUrl, $this->queryParam, $this->youtubeApiKey);
        $contentJsonChannel = file_get_contents($contentUrl);
        $contentChannel = json_decode($contentJsonChannel);

        $playListId = $contentChannel->items[0]->contentDetails->relatedPlaylists->uploads;

        $playlistUrl = sprintf("%splaylistItems?part=snippet&playlistId=%s&key=%s", $this->apiBaseUrl, $playListId, $this->youtubeApiKey);
        $contentJsonPlaylist = file_get_contents($playlistUrl);
        $contentPlaylist = json_decode($contentJsonPlaylist);

        if ($contentPlaylist->items) {
            $entries = $contentPlaylist->items;
        }

        if ($debug) {
//            echo sizeof($entries);
            var_dump($entries);
            die();
        }

        return $entries;

    }

    public static function getId($post) {
        return $post->id;
    }

    public static function getCreatedTime($post) {
        return strtotime($post->snippet->publishedAt);
    }

    public static function getTitle($post) {
        return $post->snippet->title;
    }

    public static function getMessage($post) {
        return $post->snippet->description;
    }

    public static function getPicture($post) {
        return $post->snippet->thumbnails->default->url;
    }

    public static function getPermaLink($post) {
        return 'https://www.youtube.com/watch?v=' . $post->snippet->resourceId->videoId;
    }

}
