<?php


namespace Dmkzwo\ContaoSocialmediaBundle\Classes;


use Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel;

class SocialmediaDca
{
    public static function getTwitterAccountBackendOptions()
    {
        return self::getSocialMediaAccountBackendOptions('Dmkzwo\ContaoSocialmediaBundle\Model\TwitterAccountModel');
    }

    public static function getFlickrAccountBackendOptions()
    {
        return self::getSocialMediaAccountBackendOptions('Dmkzwo\ContaoSocialmediaBundle\Model\FlickrAccountModel');
    }

    public static function getFacebookAccountBackendOptions()
    {
        return self::getSocialMediaAccountBackendOptions('Dmkzwo\ContaoSocialmediaBundle\Model\FacebookAccountModel');
    }

    public static function getInstagramAccountBackendOptions()
    {
        return self::getSocialMediaAccountBackendOptions('Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel');
    }

    public static function getYoutubeAccountBackendOptions()
    {
        return self::getSocialMediaAccountBackendOptions('Dmkzwo\ContaoSocialmediaBundle\Model\YoutubeAccountModel');
    }

    public static function getSocialMediaAccountBackendOptions($accountClassname)
    {
        $accounts = $accountClassname::findAll();

        $options = [];

        foreach ($accounts as $isAccount) {
            $options[$isAccount->id] = $isAccount->accountName;
        }

        return $options;
    }

    public function getAccountBackendOptions()
    {
        $isAccounts = InstagramAccountModel::findAll();


        $options = [];

        foreach ($isAccounts as $isAccount) {
            $options[$isAccount->userId] = $isAccount->accountName;
        }

        return $options;
    }

    public function getNumStartOptions()
    {
        $options = ['-1' => 'Alle'];

        for ($i=1; $i<=10; $i++) {
            $options['' . $i] = $i;
        }

        return $options;
    }

}
