
// global.jQuery = require("jquery");

(function( $ ) {

    'use strict';

    // Default options
    var defaults = {};



    // Constructor, initialise everything you need here
    var DzSm = function (element, options) {

      this.element = element;
      this.options = options;

      this.init();

    };


    // DzTest methods and shared properties
  DzSm.prototype = {

      constructor: DzSm,

      /** @private */
      init: function () {

          // console.log('init smnr');

        var _self = this;

        this.element.find(".js-toggle-hidden").click(function(event) {
          if ($(event.currentTarget).hasClass('no-action')) {
            return;
          }
          _self.element.find(".ce-dz-socialmedia-hidden").slideToggle();
          if ($(this).html() == 'Weitere ansehen') {
            $(this).html('Weitere ausblenden');
          } else {
            $(this).html('Weitere ansehen');
          }
        });

      }

    };


    // Create the jQuery DzTest
    $.fn.dzSm = function (options) {

      options = $.extend(true, {}, defaults, options);

      return this.each(function () {
        var $this = $(this);
        // Create a new instance for each element in the matched jQuery set
        // Also save the instance so it can be accessed later to use methods/properties etc
        // e.g.
        //    var instance = $('.element').data('plugin');
        //    instance.someMethod();

        $this.data('dzSm', new DzSm($this, options));

        //$this.data('testplugin').someMethod();

      });

    };

    // Expose defaults and Constructor (allowing overriding of prototype methods for example)
    //$.fn.dzContentPager.defaults = defaults;
    //$.fn.dzContentPager.DzContentPager = DzContentPager;


}( jQuery ));
