<?php


Contao\System::loadLanguageFile('tl_content');

$GLOBALS['TL_DCA']['tl_dz_socialmedia_flickr_post'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'enableVersioning' => true,
//        'onload_callback' => array
//        (
//            array('tl_dz_socialmedia_flickr_post', 'checkPermission')
//        ),
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 2,
            'fields' => array('tstamp'),
            'panelLayout' => 'sort,search;filter;limit',
            //'headerFields'            => array('name_de', 'name_en'),
//            'paste_button_callback' => array('tl_dz_socialmedia_flickr_post', 'pasteElement'),
            'disableGrouping' => true,
        ),
        'label' => array
        (
            'fields' => array('message'),
            'format' => '%s',
            'showColumns' => true,
            'label_callback' => ['tl_dz_socialmedia_flickr_post', 'customLabel']
//            'label_callback' => array('tl_dz_socialmedia_flickr_post', 'generateLabel'),
        ),
        'global_operations' => array
        (
//            'all' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
//                'href' => 'act=select',
//                'class' => 'header_edit_all',
//                'attributes' => 'onclick="Backend.getScrollOffset()" accesskey="e"'
//            )
        ),
        'operations' => array
        (
//            'edit' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['tl_content']['edit'],
//                'href' => 'act=edit',
//                'icon' => 'edit.svg'
//            ),
//            'copy' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_flickr_post']['copy'],
//                'href' => 'act=paste&amp;mode=copy',
//                'icon' => 'copy.svg'
//            ),
//            'cut' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_flickr_post']['cut'],
//                'href' => 'act=paste&amp;mode=cut',
//                'icon' => 'cut.svg'
//            ),
//            'delete' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['tl_content']['delete'],
//                'href' => 'act=delete',
//                'icon' => 'delete.svg',
//                'attributes' => 'onclick="if(!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\'))return false;Backend.getScrollOffset()"'
//            ),
            'toggle' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_flickr_post']['toggle'],
                'icon' => 'visible.svg',
                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
                'button_callback' => array('tl_dz_socialmedia_flickr_post', 'toggleIcon')
            ),
            'toggleHide' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_flickr_post']['toggleHide'],
                'icon' => 'invisible.svg',
//                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
                'button_callback' => array('tl_dz_socialmedia_flickr_post', 'toggleHideOnWall')
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_content']['show'],
                'href' => 'act=show',
                'icon' => 'show.svg'
            )
        )
    ),

    // Palettes
    'palettes' => array
    (
//        'default'                     => 'name_de,name_en;{publish_legend},published'
//        '__selector__' => ['addcoverimage'],
//        'default' => 'title,alias,identifier,releasedate,docfile,language,targetsd,targetev,published,description,longdescription,addcoverimage;{meta_legend},types,doctypes,allcategories,categories'
        'default' => 'postId,published'
    ),

//    'subpalettes' => array
//    (
//        'addcoverimage' => 'coverimage',
//    ),


// Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment"
        ),
        'pid' => array
        (
            'sql' => "int(10) unsigned NOT NULL default '0'"
        ),
        'accountId' => array
        (
            'sql' => "int(10) unsigned NOT NULL default 0",
            'filter' => true
        ),
        'userId' => array
        (
            'sql' => "varchar(255) NOT NULL default ''",
        ),
        'tstamp' => array
        (
            'flag' => 12,
            'sql' => "int(10) unsigned NOT NULL default 0"
        ),
        'published' => array
        (
            'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_flickr_post']['published'],
            'exclude' => true,
            'filter' => true,
            'flag' => 2,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
            'sql' => "char(1) NOT NULL default ''"
        ),
        'hideOnWall' => array
        (
            'exclude' => true,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
            'sql' => "char(1) NOT NULL default ''"
        ),
        'postId' => array
        (
            'exclude' => false,
            'sorting' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),
        'userName' => array
        (
            'exclude' => false,
            'sorting' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),
        'title' => array
        (
            'exclude' => false,
            'sorting' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),
        'message' => array
        (
            'exclude' => false,
            'sorting' => false,
            'inputType' => 'textarea',
            'eval' => array('mandatory' => true, 'tl_class' => 'w50'),
            'sql' => "text NULL"
        ),
        'mediaUrl' => array
        (
            'exclude' => false,
            'sorting' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'tl_class' => 'w50'),
            'sql' => "text NULL"
        ),
        'mediaSrc' => array
        (
            'exclude' => false,
            'sorting' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'tl_class' => 'w50'),
            'sql' => "text NULL"
        ),
        //        'mediaType' => array
//        (
//            'exclude' => false,
//            'sorting' => false,
//            'inputType' => 'text',
//            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
//            'sql' => "varchar(255) NOT NULL default ''"
//        ),
        'permaLink' => array
        (
            'exclude' => false,
            'sorting' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'tl_class' => 'w50'),
            'sql' => "text NULL"
        ),

    )
);


/**
 * Provide miscellaneous methods that are used by the data configuration array.
 *
 * @author Leo Feyer <https://github.com/leofeyer>
 */
class tl_dz_socialmedia_flickr_post extends Contao\Backend
{

    /**
     * Import the back end user object
     */
    public function __construct()
    {
        parent::__construct();
        $this->import('Contao\BackendUser', 'User');
    }

    /**
     * Check permissions to edit table tl_dz_socialmedia_flickr_post
     */
    public function checkPermission()
    {
        $bundles = Contao\System::getContainer()->getParameter('kernel.bundles');

    }

    public function customLabel($row, $label) {
        $mediaFile = \Dmkzwo\ContaoSocialmediaBundle\Library\SocialmediaHelper::existImage($row['mediaSrc']);

        if ($mediaFile) {
            $label = sprintf('<div style="display: flex;"><img src="/%s" style="max-width: 150px; height: auto;"><p style="margin-left: 10px;"><strong>%s - %s</strong><br><br>%s</p></div>', $mediaFile, $row['accountId'], date('d.m.Y H:i:s', $row['tstamp']), $row['message']);
        }

        return $label;
    }

    public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (strlen(Input::get('tid'))) {
            $this->setVisibility(Input::get('tid'), (Input::get('state') == 1));
            $this->redirect($this->getReferer());
        }

        $href .= '&tid=' . $row['id'] . '&state=' . ($row['published'] ? 0 : 1);

        if (!$row['published']) {
            $icon = 'invisible.gif';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '" ' . $attributes . '>' . Image::getHtml($icon, $label, 'data-state="' . ($row['published'] ? 1 : 0) . '"') . '</a> ';
    }

    public function setVisibility($id, $isVisible)
    {
        $post = \Dmkzwo\ContaoSocialmediaBundle\Model\FacebookPostModel::findByPk($id);
        $post->published = $isVisible ? 1 : 0;
        $post->save();
    }

    public function toggleHideOnWall($row, $href, $label, $title, $icon, $attributes)
    {
        if (strlen(Input::get('hid'))) {
            $this->setHideOnWall(Input::get('hid'), (Input::get('state') == 1));
            $this->redirect($this->getReferer());
        }

        $href .= '&hid=' . $row['id'] . '&state=' . ($row['hideOnWall'] ? 0 : 1);

        if (!$row['hideOnWall']) {
            $icon = 'visible.gif';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '" ' . $attributes . '>' . Image::getHtml($icon, $label, 'data-state="' . ($row['hideOnWall'] ? 1 : 0) . '"') . '</a> ';
    }

    public function setHideOnWall($id, $isVisible)
    {
        $post = \Dmkzwo\ContaoSocialmediaBundle\Model\FacebookPostModel::findByPk($id);
        $post->hideOnWall = $isVisible ? 1 : 0;
        $post->save();
    }

//    public function pasteElement(DataContainer $dc, $row, $table, $cr, $arrClipboard)
//    {
//        $imagePasteAfter = Image::getHtml('pasteafter.gif',
//            sprintf($GLOBALS['TL_LANG'][$table]['pasteafter'][1], $row['id']));
//        return '<a href="' . $this->addToUrl('act=' . $arrClipboard['mode'] . '&mode=1&pid=' . $row['id']) . '" title="' . specialchars(sprintf($GLOBALS['TL_LANG'][$table]['pasteafter'][1],
//                $row['id'])) . '" onclick="Backend.getScrollOffset()">' . $imagePasteAfter . '</a> ';
//    }

}
