<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Library;

use Dmkzwo\ContaoSocialmediaBundle\Classes\FacebookApi;
use Dmkzwo\ContaoSocialmediaBundle\Model\FacebookAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\FacebookPostModel;


class FacebookUpdater extends AbstractAccountUpdater
{
    public function __construct($account, $config)
    {
        parent::__construct($account, $config);

        $this->api = new FacebookApi($account);
    }

    protected function createOrUpdatePost($post) {
//        echo '<pre>';
//        var_dump($post);
//        echo '</pre>';
//        echo '<br><br>';
//        return;

        $postId = FacebookApi::getId($post);

        $postObj = FacebookPostModel::findOneBy('postId', $postId);

        if ($postObj) {
            // update
            $action = 'UPDATE';

            $this->setUpdateData($post, $postObj);


        } else {
            // create
            $action = 'CREATE';

            $postObj = new FacebookPostModel();

            $this->setBaseData($post, $postObj);
            $this->setUpdateData($post, $postObj);

        }

        $postObj->save();

        $this->saveImage($postId, $postObj);

        $this->logPost($postObj, $action);

    }

    protected function setUpdateData($post, &$postObj) {
        $postObj->postId = FacebookApi::getId($post);
        $postObj->tstamp = FacebookApi::getCreatedTime($post);

        $postObj->message = FacebookApi::getMessage($post);
        $postObj->permaLink = FacebookApi::getPermaLink($post, $this->account);
        $postObj->mediaUrl = FacebookApi::getPicture($post);
        $postObj->totalLikes = FacebookApi::getTotalLikes($post);
    }
}
