<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Classes;


use Dmkzwo\ContaoSocialmediaBundle\Library\AbstractAccountUpdater;

class InstagramApi
{
    private $user;
    private $accessToken;
    private $apiBaseUrl;
    private $graphBaseUrl;

    public function __construct($account)
    {
        $this->apiBaseUrl = \System::getContainer()->getParameter('instagram.api_base_url');
        $this->graphBaseUrl = \System::getContainer()->getParameter('instagram.graph_base_url');

        $this->accessToken = $account->accessToken;

        $this->user = $this->getUser();
    }

    public function getUser() {
        $params = array(
            'endpoint_url' => $this->graphBaseUrl . 'me',
            'type' => 'GET',
            'url_params' => array(
                'fields' => 'id,username,media_count,account_type'
            )
        );

        $response = $this->makeApiCall($params);

        return $response;
    }

    public function getUserId() {
        return $this->user['id'];
    }

    public function getAccountName() {
        return $this->user['username'];
    }

//    public function getUserPosts() {
//        $params = array(
//            'endpoint_url' => $this->graphBaseUrl . $this->user['id'] . '/media',
//            'type' => 'GET',
//            'url_params' => array(
//                'fields' => 'id,caption,media_type,media_url,permalink,timestamp,thumbnail_url'
//            )
//        );
//
//        $response = $this->makeApiCall($params);
//
//        return $response;
//    }

    public function getFeeds($debug = false) {
        $params = array(
            'endpoint_url' => $this->graphBaseUrl . $this->user['id'] . '/media',
            'type' => 'GET',
            'url_params' => array(
                'fields' => 'id,caption,media_type,media_url,permalink,timestamp,thumbnail_url'
            )
        );

        $response = $this->makeApiCall($params);

        if ($debug) {
            var_dump($response['data']);
            die();
        }

        return $response['data'];
    }

//    public function getUserProfilePicture() {
//        $params = array(
//            'endpoint_url' => $this->graphBaseUrl . $this->user['id'] . '/picture',
//            'type' => 'GET',
//            'url_params' => array(
//                'redirect' => '0'
//            )
//        );
//
//        $response = $this->makeApiCall($params);
//
//        return $response;
//    }

    protected function makeApiCall($params) {
        $ch = curl_init();

        $endpointUrl = $params['endpoint_url'];

        if ('POST' == $params['type']) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params['url_params']));
            curl_setopt($ch, CURLOPT_POST, 1);

        } elseif ('GET' == $params['type']) {
            $params['url_params']['access_token'] = $this->accessToken;

            $endpointUrl .= '?' . http_build_query($params['url_params']);
        }

        curl_setopt($ch, CURLOPT_URL, $endpointUrl);

        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);

        curl_close($ch);

//        echo $response;
//        echo '<br><br>';

        $responseArr = json_decode($response, true);

        if (isset($responseArr['error'])) {
//                        var_dump($responseArr);
//            die();
            throw new \Exception($responseArr['error']['message']);

        } else {
            return $responseArr;
        }
    }

    public static function getId($post)
    {
        return $post['id'];
    }

    public static function getCreatedTime($post)
    {
        return strtotime($post['timestamp']);
    }

    public static function getCaption($post)
    {
        return $post['caption'];
    }

    public static function getPicture($post)
    {
        if ($post['media_type'] == 'VIDEO') {
            return $post['thumbnail_url'];
        }

        return $post['media_url'];
    }

    public static function getMediaType($post)
    {
        return $post['media_type'];
    }

    public static function getPermaLink($post)
    {
        return $post['permalink'];
    }

}
