<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Classes;

use Facebook\Facebook;

class FacebookApi
{
    private $appId;
    private $appSecret;
    private $queryParam;

    private $user;
    private $accessToken;

    protected $facebookAccessDataFound = false;
    protected $facebookSession;

    protected $limit = 4;

    /**
     * InstagramApi constructor.
     * @param $params
     */
    public function __construct($account)
    {
        $this->appId = $account->appId;
        $this->appSecret = $account->appSecret;
        $this->accessToken = $account->accessToken;
        $this->queryParam = $account->queryParam;

        if (strlen($this->appId) && ($this->appSecret) && ($this->accessToken)) {
            $this->facebookAccessDataFound = true;

            $graphVersion = \System::getContainer()->getParameter('facebook.graph_version');

            $fb = new Facebook([
                'app_id' => $this->appId,
                'app_secret' => $this->appSecret,
                'default_graph_version' => $graphVersion,
            ]);

            $fb->setDefaultAccessToken($this->accessToken);

            $this->facebookSession = $fb;

        } else {
            $this->facebookSession = false;
        }

    }

    public function getFeeds($debug = false)
    {

        if (!$this->facebookAccessDataFound) {
            return array();
        }

        $queryStr = sprintf("/%s/feed?limit=%s&fields=id,created_time,attachments,likes", $this->queryParam, $this->limit);

        try {
            $userPosts = $this->facebookSession->get(
                $queryStr,
                $this->accessToken
            );

            $postBody = $userPosts->getDecodedBody();
            $allEntries = $postBody["data"];

        } catch (FacebookResponseException $e) {
            // display error message
            exit();
        } catch (FacebookSDKException $e) {

            // display error message
            exit();
        }


        if ($debug) {
            var_dump($allEntries);
            die();
        }

//        var_dump($allEntries);
//        echo sizeof($allEntries);


        $entries = array();

        $counter = 0;
        foreach ($allEntries as $entry) {
//            echo $counter;
//            $propertyNames = $entry->getPropertyNames();
            $propertyNames = array_keys($entry);
//            var_dump($propertyNames);

            $entry['postEntry'] = $this->getPost($entry);
//            sleep(5);

            $totalLikes = 0;
            if (in_array('story', $propertyNames)) {
                echo 'story found -------------------------<br>';
                continue;
            } else {
                $totalLikes = $this->getTotalLikesForPost($entry);
            }
            $entry['totalLikes'] = $totalLikes;

            $entries[] = $entry;

//            echo '<pre>';
//            var_dump($entry);
//            echo '</pre>';
            $counter++;
        }

//        var_dump($entries);
//        die();

//        echo sizeof($entries);
//        die();


        return $entries;

    }


    public function getTotalLikesForPost($entry)
    {
        $likeCount = 0;

        try {
            $userPosts = $this->facebookSession->get(
                "/" . $entry['id'] . "/likes?summary=total_count",
                $this->accessToken
            );

            $postBody = $userPosts->getDecodedBody();
            $likeCount = $postBody['summary']['total_count'];

//            var_dump($postBody);
//            die();

        } catch (FacebookResponseException $e) {
//            echo $e->getMessage();
        } catch (FacebookSDKException $e) {
//            echo $e->getMessage();
        } catch (\Exception $e) {
//            echo $e->getMessage();
        }

        return $likeCount;
    }


    public function getPost($entry)
    {
//        echo $entry['id'];
//        echo "\n";

        try {
            $userPosts = $this->facebookSession->get(
                "/" . $entry['id'],
                $this->accessToken
            );

            $postBody = $userPosts->getDecodedBody();


//            var_dump($postBody);
//            die();

        } catch (FacebookResponseException $e) {
            echo $e->getMessage();
        } catch (FacebookSDKException $e) {
            echo $e->getMessage();
        } catch (\Exception $e) {
            echo $e->getMessage();
        }

        return $postBody;
    }



    public static function getId($post)
    {
        return $post['id'];
    }

    public static function getCreatedTime($post)
    {
        return strtotime($post['created_time']);
    }

    public static function getMessage($post)
    {
        return $post['postEntry']['message'];
    }

    public static function getPicture($post)
    {
        return self::getValue(
            $post['attachments']['data'][0]['media']['image'],
            'src'
        );
    }

    public static function getTotalLikes($post)
    {
        return $post['totalLikes'];
    }

    public static function getPermaLink($post)
    {
        return 'https://www.facebook.com/' . str_replace('_', '/posts/', $post['id']);
    }

//    protected function getLikes($entry)
//    {
////        echo '<pre>';
////        var_dump($entry['likes']);
////        echo '</pre>';
//
//        $likes = $this->getValue($entry['likes'], 'data');
//
//        if (is_array($likes)) {
//            return sizeof($likes);
//        }
//
//        return 0;
//    }

    protected static function getValue($baseArr, $key)
    {
        if (
            is_array($baseArr) &&
            array_key_exists($key, $baseArr)
        ) {
            return $baseArr[$key];
        }

        return '';
    }

}
