<?php


namespace Dmkzwo\ContaoSocialmediaBundle\Library;


class SocialmediaHelper
{

    public function myReplaceInsertTags($strTag) {
        $arrSplit = explode('::', $strTag);

        if ($arrSplit[0] == '[inserttagname]') {
            if (!$arrSplit[1]) {
                return '';
            }

            return '...';
        }

        return false; // this is important!!!

    }

    public static function getMediaImage($userId, $mediaId) {
//        $relMediaFile = \System::getContainer()->getParameter('instagram.social_media_dir') . DIRECTORY_SEPARATOR . $userId . DIRECTORY_SEPARATOR . $mediaId . '.jpg';
        $relMediaFile = \System::getContainer()->getParameter('instagram.social_media_dir') . DIRECTORY_SEPARATOR . $mediaId . '.jpg';
        $absMediaFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $relMediaFile;

        if (file_exists($absMediaFile) && is_file($absMediaFile)) {
            return $relMediaFile;
        }

        return false;
    }

    public static function getFacebookImage($mediaId) {
        $relMediaFile = \System::getContainer()->getParameter('facebook.social_media_dir') . DIRECTORY_SEPARATOR . $mediaId . '.jpg';
        $absMediaFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $relMediaFile;

        if (file_exists($absMediaFile) && is_file($absMediaFile)) {
            return $relMediaFile;
        }

        return false;
    }

    public static function getFlickrImage($mediaId) {
        $relMediaFile = \System::getContainer()->getParameter('flickr.social_media_dir') . DIRECTORY_SEPARATOR . $mediaId . '.jpg';
        $absMediaFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $relMediaFile;

        if (file_exists($absMediaFile) && is_file($absMediaFile)) {
            return $relMediaFile;
        }

        return false;
    }

    public static function prepareCaption($caption) {
        $caption .= ' ';
        $caption = str_replace('"', '%q%', $caption);
//        $caption = preg_replace('/#(.+?)\s/', '<a href=%s%https://www.instagram.com/explore/tags/${1}%s% target="_blank">#${1}</a> ', $caption);
//        $caption = preg_replace('/#(.+?)\s/', '%a1%${1}%a2%${1}%a3% ', $caption);
        $caption = preg_replace('/#(.+?)\s/', '%a1%${1}%a2%${1}%a3% ', $caption);
        $caption = preg_replace('/@(.+?)\s/', '%u1%${1}%u2%${1}%u3% ', $caption);
        $caption = str_replace("\n", '<br>', $caption);
        $caption = str_replace("?", '', $caption);

        return $caption;
    }

    public static function prepareCaptionHtml($caption) {
        $caption .= ' ';
//        $caption = str_replace('"', '%q%', $caption);
//        $caption = preg_replace('/#(.+?)\s/', '<a href=%s%https://www.instagram.com/explore/tags/${1}%s% target="_blank">#${1}</a> ', $caption);
//        $caption = preg_replace('/#(.+?)\s/', '%a1%${1}%a2%${1}%a3% ', $caption);
        $caption = preg_replace('/#(.+?)\s/', '<a href="https://www.instagram.com/explore/tags/${1}" target="_blank">#${1}</a> ', $caption);
        $caption = preg_replace('/@(.+?)\s/', '<a href="https://www.instagram.com/${1}" target="_blank">@${1}</a> ', $caption);
        $caption = str_replace("\n", '<br>', $caption);
        $caption = str_replace("?", '', $caption);

        return $caption;
    }

    public static function prepareTimestamp($timestamp) {
        $secondsSincePosted = time() - $timestamp;

        if ($secondsSincePosted <= 120) {
            return $GLOBALS['TL_LANG']['dz_socialmedia']['posted_now'];
        } elseif ($secondsSincePosted <= 3600) {
            return floor($secondsSincePosted/60) . ' ' . $GLOBALS['TL_LANG']['dz_socialmedia']['posted_minutes'];
        } elseif ($secondsSincePosted <= 7200) {
            return '1 ' . $GLOBALS['TL_LANG']['dz_socialmedia']['posted_hour'];
        } elseif ($secondsSincePosted <= 24 * 3600) {
            return floor($secondsSincePosted/3600) . ' ' . $GLOBALS['TL_LANG']['dz_socialmedia']['posted_hours'];
        } elseif ($secondsSincePosted <= 48 * 3600) {
            return $GLOBALS['TL_LANG']['dz_socialmedia']['posted_day'];
        } elseif ($secondsSincePosted <= 7 * 24 * 3600) {
            return floor($secondsSincePosted/(24 * 3600)) . ' ' . $GLOBALS['TL_LANG']['dz_socialmedia']['posted_days'];
        } else {
            return floor($secondsSincePosted/(7 * 24 * 3600)) . ' ' . $GLOBALS['TL_LANG']['dz_socialmedia']['posted_weeks'];
        }
    }
}

