<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Classes;

use Abraham\TwitterOAuth\TwitterOAuth;

class TwitterApi
{
    private $twitterConsumerKey;
    private $twitterConsumerSecret;
    private $twitterAccessToken;
    private $twitterAccessTokenSecret;
    private $queryParam;

    protected $twitterAccessDataFound = false;
    protected $twitterSession;


    public function __construct($account)
    {
        $this->twitterConsumerKey = $account->twitterConsumerKey;
        $this->twitterConsumerSecret = $account->twitterConsumerSecret;
        $this->twitterAccessToken = $account->twitterAccessToken;
        $this->twitterAccessTokenSecret = $account->twitterAccessTokenSecret;
        $this->queryParam = $account->queryParam;

        if (strlen($this->twitterConsumerKey) && ($this->twitterConsumerSecret) && ($this->twitterAccessToken) && ($this->twitterAccessTokenSecret) && ($this->queryParam)) {
            $this->twitterAccessDataFound = true;

            $this->twitterSession = new TwitterOAuth($this->twitterConsumerKey, $this->twitterConsumerSecret, $this->twitterAccessToken, $this->twitterAccessTokenSecret);
//    $connection->host = "https://api.twitter.com/1.1/";

        } else {
            $this->twitterSession = false;
        }

    }

    public function getFeeds() {

        $entries = $this->twitterSession->get('statuses/user_timeline', array('screen_name' => $this->queryParam));

        return $entries;

    }

    public static function getPath($account) {
        return $account->queryParam;
    }

    public static function getId($post) {
        return $post->id_str;
    }

    public static function getCreatedTime($post) {
        return strtotime($post->created_at);
    }

    public static function getUserName($post) {
        if (self::isRetweet($post)) {
            return $post->retweeted_status->user->name;
        } else {
            return $post->user->name;
        }
    }

    public static function getUserScreenName($post) {
            if (self::isRetweet($post)) {
                $screenName = strip_tags($post->retweeted_status->text);
            } else {
                $screenName = $post->retweeted_status->user->screen_name;
            }

            if (empty($screenName)) {
                $screenName = '';
            }

            return $screenName;
    }

    public static function getMessage($post) {
        if (self::isRetweet($post)) {
            return strip_tags($post->retweeted_status->text);
        } else {
            return strip_tags($post->text);
        }
    }

    public static function getPermaLink($post, $account) {
        return sprintf("http://www.twitter.com/%s/statuses/%s", self::getPath($account), self::getId($post));
    }

    public static function isRetweet($post) {
        return ($post->retweeted_status != null);
    }

    public static function getPicture($post)
    {
        if (self::isRetweet($post)) {
            return $post->retweeted_status->user->profile_image_url_https;
        } else {
            return str_replace('http:', 'https:', $post->user->profile_image_url);
        }

    }

}
