<?php

/*
 * This file is part of [dmkzwo/contao-hello-world-bundle].
 *
 * (c) Dmkzwo
 *
 * @license LGPL-3.0-or-later
 */

namespace Dmkzwo\ContaoSocialmediaBundle\Classes\Command;

use Contao\CoreBundle\Framework\FrameworkAwareInterface;
use Contao\CoreBundle\Framework\FrameworkAwareTrait;
use Contao\CoreBundle\Util\PackageUtil;
use Dmkzwo\ContaoSocialmediaBundle\Library\SocialmediaUpdater;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Question\ConfirmationQuestion;
use Symfony\Component\Console\Question\Question;

class SocialmediaUpdateCommand extends Command // implements FrameworkAwareInterface
{
    // use FrameworkAwareTrait;

    private $framework;

    public function __construct($framework)
    {
        $this->framework = $framework;

        parent::__construct();
    }

    protected function configure()
    {
        $this
            ->setName('socialmedia:update')
            ->setDescription('Retrieve data from social media feeds')
        ;

        $this->addOption(
            'output',  // use with --optionname=...
            'o',           // single char (OR NULL), use -with -o ...
            InputOption::VALUE_NONE,  // or VALUE_OPTIONAL, VALUE_NONE (boolean), VALUE_IS_ARRAY (can be combined)
            'enable output'       // Explanation for this option
        );
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->framework->initialize();

        $config = [];

        $config['command'] = '1';
        $config['email'] = '1';

        if (!empty($input->getOption('output'))) {
            $config['output'] = '1';
        }

        $command = new SocialmediaUpdater($config);
        $command->run();

        return 0;
    }
}

