<?php


namespace Dmkzwo\ContaoSocialmediaBundle\Classes;


use Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel;

class SocialmediaDca
{
    public static function getTwitterAccountBackendOptions()
    {
        return self::getSocialMediaAccountBackendOptions('Dmkzwo\ContaoSocialmediaBundle\Model\TwitterAccountModel');
    }

    public static function getSocialMediaAccountBackendOptions($accountClassname)
    {
        $accounts = $accountClassname::findAll();

        $options = [];

        foreach ($accounts as $isAccount) {
            $options[$isAccount->id] = $isAccount->accountName;
        }

        return $options;
    }

    public function getAccountBackendOptions()
    {
        $isAccounts = InstagramAccountModel::findAll();


        $options = [];

        foreach ($isAccounts as $isAccount) {
            $options[$isAccount->userId] = $isAccount->accountName;
        }

        return $options;
    }

    public function getNumStartOptions()
    {
        $options = ['-1' => 'Alle'];

        for ($i=1; $i<=10; $i++) {
            $options['' . $i] = $i;
        }

        return $options;
    }

}
