<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Library;

use Dmkzwo\ContaoSocialmediaBundle\Classes\FacebookApi;
use Dmkzwo\ContaoSocialmediaBundle\Classes\FlickrApi;
use Dmkzwo\ContaoSocialmediaBundle\Classes\InstagramApi;
use Dmkzwo\ContaoSocialmediaBundle\Classes\TwitterApi;
use Dmkzwo\ContaoSocialmediaBundle\Model\FacebookAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\FlickrAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\TwitterAccountModel;


class SocialmediaUpdater
{
    protected $config;

//    public function __construct($output = false, $log = false)
    public function __construct($config = [])
    {
        $this->config = $config;
//        $this->config = [
//            'output' => $output,
//            'log' => $log,
//        ];
    }


    public function run()
    {
        self::updateInstagramAccounts();
        self::updateFacebookAccounts();
        self::updateTwitterAccounts();
        self::updateFlickrAccounts();
        self::updateYoutubeAccounts();
    }

    protected function updateInstagramAccounts()
    {
        $this->updateAccounts(
            'instagram',
            'Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel',
            'Dmkzwo\ContaoSocialmediaBundle\Library\InstagramUpdater'
        );

//        $isAccounts = InstagramAccountModel::findBy(['published=?'], ['1']);
//
//        // loop over accounts
//        foreach ($isAccounts as $isAccount) {
//            // update account
//            $params = [
////                'appId' => $isAccount->appId,
////                'appSecret' => $isAccount->appSecret,
//                'accessToken' => $isAccount->accessToken,
//            ];
//
//            try {
//                $isApi = new InstagramApi($params);
//
//                $isUpdater = new InstagramUpdater($isAccount->id, $isApi, $this->config);
//                $isUpdater->run();
//
//            } catch (\Exception $exception) {
//                $this->handleError($isAccount, 'Retrieving instagram posts failed', $exception);
//            }
//        }

    }

    protected function updateFacebookAccounts()
    {
        $this->updateAccounts(
            'facebook',
            'Dmkzwo\ContaoSocialmediaBundle\Model\FacebookAccountModel',
            'Dmkzwo\ContaoSocialmediaBundle\Library\FacebookUpdater'
        );
    }

    protected function updateTwitterAccounts()
    {
        $this->updateAccounts(
            'twitter',
            'Dmkzwo\ContaoSocialmediaBundle\Model\TwitterAccountModel',
            'Dmkzwo\ContaoSocialmediaBundle\Library\TwitterUpdater'
        );
    }

    protected function updateFlickrAccounts()
    {
        $this->updateAccounts(
            'flickr',
            'Dmkzwo\ContaoSocialmediaBundle\Model\FlickrAccountModel',
            'Dmkzwo\ContaoSocialmediaBundle\Library\FlickrUpdater'
        );
    }

    protected function updateYoutubeAccounts()
    {
        $this->updateAccounts(
            'youtube',
            'Dmkzwo\ContaoSocialmediaBundle\Model\YoutubeAccountModel',
            'Dmkzwo\ContaoSocialmediaBundle\Library\YoutubeUpdater'
        );
    }

    protected function updateAccounts($type, $accountModelClassname, $updateClassname)
    {
        $accounts = $accountModelClassname::findBy(['published=?'], ['1']);

        if ($accounts) {
            $config = $this->config;
            $config['accountType'] = $type;

            // loop over accounts
            foreach ($accounts as $account) {
                if (!$config['force']) {
                    // check cron settings only if not in force mode (cli)
                    if (!$account->isCronActivated() || !$account->isCronDue()) {
                        continue;
                    }
                }

                try {
                    $updater = new $updateClassname($account, $config);
                    $updater->run();

                } catch (\Exception $exception) {
                    $this->handleError($account, 'Retrieving ' . $config['accountType'] . ' posts failed', $exception, $config);
                }
            }
        }
    }

    protected function handleError($account, $errMessage, $exception, $config)
    {
        \System::log($errMessage . ': ' . $exception->getMessage(), __METHOD__, TL_ERROR);

        if ($this->config['command']) {
            $entryStr = sprintf('%s %s [%s]: %s',
                date('d.m.Y H:i:s'),
                $account->accountName,
                ucfirst($config['accountType']),
                $errMessage . ' - ' . $exception->getMessage()
            );
            echo $entryStr . "\n";
        }

        if ($this->config['email'] && !empty($account->notifyOnError) && !$account->notificationDisabled) {
            $emailRecipients = explode(',', preg_replace('/\s+/', '', $account->notifyOnError));

            foreach ($emailRecipients as $emailRecipient) {
                if (\Validator::isEmail($emailRecipient)) {
                    $email = new \Email();
                    $email->subject = sprintf("contao-socialmedia-bundle [%s]: %s",
                        gethostname(),
                        $errMessage
                    );
                    $email->text = sprintf("%s\n%s [%s]\n\n%s\n",
                        date('d.m.Y H:i:s'),
                        $account->accountName,
                        ucfirst($config['accountType']),
                        $errMessage . ' - ' . $exception->getMessage()
                    );
                    $email->sendTo($emailRecipient);
                }
            }

            $account->notificationDisabled = '1';
            $account->save();
        }
    }
}
