<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Library;


abstract class AbstractAccountUpdater
{
    protected $api;
    protected $account;
    protected $config;
    protected $runStatus = [];

    protected $accountId;
    protected $imageDir;

    protected $apiClass;
    protected $postModelClass;

    public function __construct($account, $config)
    {
        $this->account = $account;
        $this->accountId = $account->id;
        $this->config = $config;

        $this->runStatus = [
            'numPosts' => 0,
            'created' => 0,
            'updated' => 0,
            'failed' => 0,
        ];
    }


    public function run() {
        $this->logPreRun();

        $this->account->cronLastrun = time();
        $this->account->save();

        $this->prepareDirectories();
        $this->updatePosts();

        $this->logPostRun();
    }

    protected function prepareDirectories() {
        $baseDir = \System::getContainer()->getParameter('dz.socialmedia.social_media_dir');
        if (!file_exists($baseDir)) {
            mkdir($baseDir, 0777, true);
        }
        if (!file_exists($baseDir . DIRECTORY_SEPARATOR . '.public')) {
            touch($baseDir . DIRECTORY_SEPARATOR . '.public');
        }

        $this->imageDir = \System::getContainer()->getParameter($this->config['accountType'] . '.social_media_dir');

        $directories = [
            $this->imageDir,
        ];

        foreach ($directories as $directory) {
            $dir = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $directory;
            if (!file_exists($dir)) {
                mkdir($dir, 0777, true);
            }
        }
    }

    protected function updatePosts() {
        $posts = $this->api->getFeeds($this->config['debug']);

        if (!isset($posts)) {
            return;
        }

        if (is_array($posts) && sizeof($posts)) {
            $this->runStatus['numPosts'] = sizeof($posts);

            foreach ($posts as $post) {
                $this->createOrUpdatePost($post);
            }
        }
//        var_dump($posts);
    }

//    abstract protected function createOrUpdatePost($post);

    protected function createOrUpdatePost($post) {
//        echo '<pre>';
//        var_dump($post);
//        echo '</pre>';
//        echo '<br><br>';
//        die();
//        return;

        try {

            $postId = $this->apiClass::getId($post);

            $postObj = $this->postModelClass::findOneBy($this->postModelClass::IDFIELD, $postId);

            if ($postObj) {
                // update
                $action = 'UPDATE';

                $this->setUpdateData($post, $postObj);

                $postObj->save();
                $this->saveImage($postId, $postObj);

                $this->runStatus['updated']++;

            } else {
                // create
                $action = 'CREATE';

                $postObj = new $this->postModelClass();

                $this->setBaseData($post, $postObj);
                $this->setUpdateData($post, $postObj);

                $postObj->save();
                $this->saveImage($postId, $postObj);

                $this->runStatus['created']++;
            }

            $this->logPost($postObj, $action);

        } catch (\Exception $e) {
            $this->logPostError($post, $e);

            $this->runStatus['failed']++;
        }
//        var_dump($postObj);

//
    }


    protected function setBaseData($post, &$postObj) {
        $postObj->pid = $this->accountId;
        $postObj->published = ($this->account->publishMode == 'blacklist') ? '1' : '';
        $postObj->hideOnWall = ($this->account->publishMode == 'blacklist') ? '' : '1';
        $postObj->accountId = $this->accountId;
    }

    abstract protected function setUpdateData($post, &$postObj);

    protected function saveImage($postId, $postObj) {
        $targetFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $this->imageDir . DIRECTORY_SEPARATOR . $postId . '.jpg';
        $relTargetFile = $this->imageDir . '/' . $postId . '.jpg';

        $sourceUrl = $postObj->mediaUrl;
        $sourceData = $this->file_get_contents_curl($sourceUrl);

        $writeStatus = file_put_contents($targetFile, $sourceData);

        if ($writeStatus) {
            $postObj->mediaSrc = $relTargetFile;
            $postObj->save();
        }
    }

    protected function file_get_contents_curl($url) {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);

        $data = curl_exec($ch);
        curl_close($ch);

        return $data;
    }

    protected function logPreRun() {
        if ($this->config['command']) {
            $entryStr = sprintf('%s - %s Feed: %s', date('d.m.Y H:i:s'), ucfirst($this->config['accountType']), $this->account->accountName);
            echo $entryStr . "\n";
        }
    }

    protected function logPostRun() {
        if ($this->config['command']) {
            $entryStr = sprintf('%s - %s Feed: %s - Found/New/Updated/Failed %s/%s/%s/%s',
                date('d.m.Y H:i:s'),
                ucfirst($this->config['accountType']),
                $this->account->accountName,
                $this->runStatus['numPosts'],
                $this->runStatus['created'],
                $this->runStatus['updated'],
                $this->runStatus['failed']
            );
            echo $entryStr . "\n";
        }
    }

    protected function logPost($postObj, $action) {
        if ($this->config['command'] && $this->config['output']) {
            $entryStr = sprintf('%s %s [%s] - %s / %s / %s',
                date('d.m.Y H:i:s'),
                $this->account->accountName,
                ucfirst($this->config['accountType']),
                $action,
                $postObj->id,
                substr($postObj->getContent(), 0, 40)
            );
            echo $entryStr . "\n";
        }
    }

    protected function logPostError($post, $exception) {
        if ($this->config['command']) {
            $entryStr = sprintf('%s %s [%s]: %s',
                date('d.m.Y H:i:s'),
                $this->account->accountName,
                ucfirst($this->config['accountType']),
                $exception->getMessage()
            );
            echo $entryStr . "\n";
        }
    }
}
