<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Elements;

use Contao\ContentModel;
use Contao\FilesModel;
use Contao\Controller;
use Contao\System;
use Contao\CoreBundle\Controller\ContentElement\AbstractContentElementController;
use Contao\CoreBundle\ServiceAnnotation\ContentElement;
use Contao\Template;
use Dmkzwo\ContaoSocialmediaBundle\Model\FlickrAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\FlickrPostModel;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @ContentElement(FlickrListElementController::TYPE)
 */
class FlickrListElementController extends AbstractSocialMediaListElementController
{
    public const TYPE = 'flickr_list_element';

    protected $accountType = 'flickr';

    protected function getAccount($model)
    {
        return FlickrAccountModel::findByPk($model->dzSmFlickrFeed);

    }

    protected function getFeedEntries($model)
    {
        $account = FlickrAccountModel::findByPk($model->dzSmFlickrFeed);

        $entries = false;

        if ($account) {
            $entries = FlickrPostModel::findBy(
                ['pid=?', 'published=?'],
                [$account->id, '1'],
                [
                    'order' => 'tstamp desc',
                    'limit' => $model->dzSmNumItems
                ]
            );
        }

        return $entries;
    }

}

