<?php


Contao\System::loadLanguageFile('tl_content');

$GLOBALS['TL_DCA']['tl_dz_socialmedia_instagram_post'] = \Dmkzwo\ContaoSocialmediaBundle\Classes\SocialmediaDca::getPostDca();

$GLOBALS['TL_DCA']['tl_dz_socialmedia_instagram_post']['list']['label']['label_callback'] = ['tl_dz_socialmedia_instagram_post', 'customLabel'];

$GLOBALS['TL_DCA']['tl_dz_socialmedia_instagram_post']['list']['operations']['toggle']['button_callback'] = array('tl_dz_socialmedia_instagram_post', 'toggleIcon');
$GLOBALS['TL_DCA']['tl_dz_socialmedia_instagram_post']['list']['operations']['toggleHide']['button_callback'] = array('tl_dz_socialmedia_instagram_post', 'toggleHideOnWall');

$addFields = [
    'userId' => array
    (
        'sql' => "varchar(255) NOT NULL default ''",
    ),
    'mediaId' => array
    (
        'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_instagram_post']['mediaId'],
        'exclude' => false,
        'sorting' => false,
        'inputType' => 'text',
        'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
        'sql' => "varchar(255) NOT NULL default ''"
    ),
    'caption' => array
    (
        'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_instagram_post']['caption'],
        'exclude' => false,
        'sorting' => false,
        'inputType' => 'textarea',
        'eval' => array('mandatory' => true, 'tl_class' => 'w50'),
        'sql' => "text NULL"
    ),
    'mediaType' => array
    (
        'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_instagram_post']['mediaType'],
        'exclude' => false,
        'sorting' => false,
        'inputType' => 'text',
        'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
        'sql' => "varchar(255) NOT NULL default ''"
    ),
];

$GLOBALS['TL_DCA']['tl_dz_socialmedia_instagram_post']['fields'] = array_merge($GLOBALS['TL_DCA']['tl_dz_socialmedia_instagram_post']['fields'], $addFields);





class tl_dz_socialmedia_instagram_post extends \Dmkzwo\ContaoSocialmediaBundle\Classes\SocialmediaPostBackend
{
    public function getPost($id) {
        return \Dmkzwo\ContaoSocialmediaBundle\Model\InstagramPostModel::findByPk($id);
    }

    public function customLabel($row, $label) {
        $account = \Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel::findByPk($row['accountId']);

        $mediaFile = \Dmkzwo\ContaoSocialmediaBundle\Library\SocialmediaHelper::existImage($row['mediaSrc']);

        if ($mediaFile) {
            $label = sprintf('<div style="display: flex; align-items: flex-start;"><img src="/%s" style="max-width: 150px; height: auto;"><p style="margin-left: 10px;"><strong>%s - %s</strong><br><br>%s</p></div>', $mediaFile, $account->accountName, date('d.m.Y H:i:s', $row['tstamp']), $row['caption']);
        } else {
            $label = sprintf('<div style="display: flex;"><p style="margin-left: 10px;"><strong>%s - %s</strong><br><br>%s</p></div>', $account->accountName, date('d.m.Y H:i:s', $row['tstamp']), $row['caption']);
        }

        return $label;
    }
}

//class tl_dz_socialmedia_instagram_post extends Contao\Backend
//{
//
//    /**
//     * Import the back end user object
//     */
//    public function __construct()
//    {
//        parent::__construct();
//        $this->import('Contao\BackendUser', 'User');
//    }
//
//    /**
//     * Check permissions to edit table tl_dz_socialmedia_instagram_post
//     */
//    public function checkPermission()
//    {
//        $bundles = Contao\System::getContainer()->getParameter('kernel.bundles');
//
//    }
//
//    public function customLabel($row, $label) {
//        $mediaFile = \Dmkzwo\ContaoSocialmediaBundle\Library\SocialmediaHelper::existImage($row['mediaSrc']);
//
//        if ($mediaFile) {
//            $label = sprintf('<div style="display: flex;"><img src="/%s" style="max-width: 150px; height: auto;"><p style="margin-left: 10px;"><strong>%s - %s</strong><br><br>%s</p></div>', $mediaFile, $row['accountId'], date('d.m.Y H:i:s', $row['tstamp']), $row['caption']);
//        }
//
//        return $label;
//    }
//
//    public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
//    {
//        if (strlen(Input::get('tid'))) {
//            $this->setVisibility(Input::get('tid'), (Input::get('state') == 1));
//            $this->redirect($this->getReferer());
//        }
//
//        $href .= '&tid=' . $row['id'] . '&state=' . ($row['published'] ? 0 : 1);
//
//        if (!$row['published']) {
//            $icon = 'invisible.gif';
//        }
//
//        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '" ' . $attributes . '>' . Image::getHtml($icon, $label, 'data-state="' . ($row['published'] ? 1 : 0) . '"') . '</a> ';
//    }
//
//    public function setVisibility($id, $isVisible)
//    {
//        $post = \Dmkzwo\ContaoSocialmediaBundle\Model\InstagramPostModel::findByPk($id);
//        $post->published = $isVisible ? 1 : 0;
//        $post->save();
//    }
//
//    public function toggleHideOnWall($row, $href, $label, $title, $icon, $attributes)
//    {
//        if (strlen(Input::get('hid'))) {
//            $this->setHideOnWall(Input::get('hid'), (Input::get('state') == 1));
//            $this->redirect($this->getReferer());
//        }
//
//        $href .= '&hid=' . $row['id'] . '&state=' . ($row['hideOnWall'] ? 0 : 1);
//
//        if (!$row['hideOnWall']) {
//            $icon = 'visible.gif';
//        }
//
//        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '" ' . $attributes . '>' . Image::getHtml($icon, $label, 'data-state="' . ($row['hideOnWall'] ? 1 : 0) . '"') . '</a> ';
//    }
//
//    public function setHideOnWall($id, $isVisible)
//    {
//        $post = \Dmkzwo\ContaoSocialmediaBundle\Model\InstagramPostModel::findByPk($id);
//        $post->hideOnWall = $isVisible ? 1 : 0;
//        $post->save();
//    }
//
////    public function pasteElement(DataContainer $dc, $row, $table, $cr, $arrClipboard)
////    {
////        $imagePasteAfter = Image::getHtml('pasteafter.gif',
////            sprintf($GLOBALS['TL_LANG'][$table]['pasteafter'][1], $row['id']));
////        return '<a href="' . $this->addToUrl('act=' . $arrClipboard['mode'] . '&mode=1&pid=' . $row['id']) . '" title="' . specialchars(sprintf($GLOBALS['TL_LANG'][$table]['pasteafter'][1],
////                $row['id'])) . '" onclick="Backend.getScrollOffset()">' . $imagePasteAfter . '</a> ';
////    }
//
//}
