<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Elements;

use Contao\ContentModel;
use Contao\FilesModel;
use Contao\Controller;
use Contao\System;
use Contao\CoreBundle\Controller\ContentElement\AbstractContentElementController;
use Contao\CoreBundle\ServiceAnnotation\ContentElement;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @ContentElement(SocialMediaListElementController::TYPE)
 */
abstract class AbstractSocialMediaListElementController extends AbstractContentElementController
{
    protected $template;
    protected $model;

    protected $baseCssClass = 'ce_dzsmlist';
    protected $accountType = '';


    protected function getResponse(Template $template, ContentModel $model, Request $request): ?Response
    {
        $GLOBALS['TL_BODY'][] = '<script src="bundles/contaosocialmedia/jquery.dzSm.js"></script>';
        $GLOBALS['TL_BODY'][] = '<script src="bundles/contaosocialmedia/init.js"></script>';

        $template->baseCssClass = $this->baseCssClass;
        $template->accountType = $this->accountType;
        $template->addCssClass = sprintf('%s--%s', $this->baseCssClass, $this->accountType);

//        $template->headline = $model->headline;
        $template->subhl = ($template->hl == 'h2') ? 'h3' : 'h4';
        $template->account = $this->getAccount($model);

        $entries = $this->getFeedEntries($model);

        if ($entries) {
            $entriesArr = $entries->fetchAll();

            if (($model->dzSmNumItemsStart != -1) && ($model->dzSmNumItemsStart < sizeof($entries))) {
                $template->entries = array_slice($entriesArr, 0, $model->dzSmNumItemsStart);
                $template->hiddenEntries = array_slice($entriesArr, $model->dzSmNumItemsStart);
            } else {
                $template->entries = $entriesArr;
            }
        }


        return $template->getResponse();
    }

    protected abstract function getFeedEntries($model);

    protected abstract function getAccount($model);
}

