<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Model;

class AccountModel extends \Model
{
    public static function findPublishedAccountIds() {
        return self::findByPublished('1')->fetchEach('id');
    }

    public static function getPublishedAccountOptions() {
        $publishedAccounts = self::findByPublished('1');

        $options = [];

        foreach ($publishedAccounts as $publishedAccount) {
            $options[$publishedAccount->id] = $publishedAccount->accountName;
        }

        return $options;
    }

    public function isCronActivated() {
        return $this->cronInterval != 0;
    }

    public function isCronDue() {
        if ($this->cronInterval == -1) {
            return true;
        }

        $cronIntervalSeconds = $this->cronInterval * 60;

        return ((time() - $this->cronLastrun) > $cronIntervalSeconds);
    }
}
