<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Library;

use Dmkzwo\ContaoSocialmediaBundle\Classes\YoutubeApi;
use Dmkzwo\ContaoSocialmediaBundle\Model\YoutubePostModel;

class YoutubeUpdater extends AbstractAccountUpdater
{
    public function __construct($account, $config)
    {
        parent::__construct($account, $config);

        $this->api = new YoutubeApi($account);

        $this->apiClass = 'Dmkzwo\ContaoSocialmediaBundle\Classes\YoutubeApi';
        $this->postModelClass = 'Dmkzwo\ContaoSocialmediaBundle\Model\YoutubePostModel';
    }

//    protected function createOrUpdatePost($post) {
////        echo '<pre>';
////        var_dump($post);
////        echo '</pre>';
////        echo '<br><br>';
////        die();
////        return;
//
//        $postId = YoutubeApi::getId($post);
//
//        $postObj = YoutubePostModel::findOneBy('postId', $postId);
//
//        if ($postObj) {
//            // update
//            $action = 'UPDATE';
//
//            $this->setUpdateData($post, $postObj);
//
//            $postObj->save();
//
//            $this->runStatus['updated']++;
//
//        } else {
//            // create
//            $action = 'CREATE';
//
//            $postObj = new YoutubePostModel();
//
//            $this->setBaseData($post, $postObj);
//            $this->setUpdateData($post, $postObj);
//
//            $postObj->save();
//
//            $this->runStatus['created']++;
//        }
//
////        var_dump($postObj);
//
//        $this->saveImage($postId, $postObj);
////
//        $this->logPost($postObj, $action);
//
//    }

    protected function setUpdateData($post, &$postObj) {
        $postObj->postId = YoutubeApi::getId($post);
        $postObj->tstamp = YoutubeApi::getCreatedTime($post);

        $postObj->title = YoutubeApi::getTitle($post);
        $postObj->message = YoutubeApi::getMessage($post);
        $postObj->permaLink = YoutubeApi::getPermaLink($post);
        $postObj->mediaUrl = YoutubeApi::getPicture($post);
    }
}
