<?php


namespace Dmkzwo\ContaoSocialmediaBundle\Library;


use Dmkzwo\ContaoSocialmediaBundle\Classes\InstagramApi;
use Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\InstagramPostModel;

class InstagramUpdater extends AbstractAccountUpdater
{
    protected $userId;
    protected $accountName;

    public function __construct($account, $config)
    {
        parent::__construct($account, $config);

        $this->api = new InstagramApi($account);

        $this->apiClass = 'Dmkzwo\ContaoSocialmediaBundle\Classes\InstagramApi';
        $this->postModelClass = 'Dmkzwo\ContaoSocialmediaBundle\Model\InstagramPostModel';

        $this->userId = $this->api->getUserId();
        $this->accountName = $this->api->getAccountName();
    }

//
//    public function run() {
//        $this->logRun();
//
//        $this->prepareDirectories();
//        $this->updatePosts();
//    }
//
//    protected function prepareDirectories() {
//        $this->imageDir = \System::getContainer()->getParameter('instagram.social_media_dir') . DIRECTORY_SEPARATOR . $this->userId;
//
//        $directories = [
//            $this->imageDir,
//        ];
//
//        foreach ($directories as $directory) {
//            $dir = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $directory;
//            if (!file_exists($dir)) {
//                mkdir($dir, 0777, true);
//            }
//        }
//    }
//
//    protected function updatePosts() {
//        $posts = $this->isApi->getUserPosts();
//
//        if (!isset($posts['data'])) {
//            return;
//        }
//
//        if (is_array($posts['data']) && sizeof($posts['data'])) {
//            foreach ($posts['data'] as $post) {
//                $this->createOrUpdatePost($post);
//            }
//        }
////        var_dump($posts);
//    }

//    protected function createOrUpdatePost($post) {
//        $postId = $post['id'];
//
//        $postObj = InstagramPostModel::findOneBy('mediaId', $postId);
//
//        if ($postObj) {
//            // update
//            $action = 'UPDATE';
//
//            $this->setUpdateData($post, $postObj);
//
//        } else {
//            // create
//            $action = 'CREATE';
//
//            $instagramAccount = InstagramAccountModel::findByPk($this->accountId);
//
//            $postObj = new InstagramPostModel();
//
//            $this->setBaseData($post, $postObj);
//            $this->setUpdateData($post, $postObj);
//        }
//
//        $postObj->save();
//
//        $this->saveImage($postId, $postObj);
//
//        $this->logPost($post, $action);
//
//    }

    protected function setBaseData($post, &$postObj)
    {
        parent::setBaseData($post, $postObj);

        $postObj->userId = $this->userId;

        $postObj->mediaId = InstagramApi::getId($post);
        $postObj->postId = InstagramApi::getId($post);
        $postObj->tstamp = InstagramApi::getCreatedTime($post);
    }

    protected function setUpdateData($post, &$postObj) {
        $postObj->caption = InstagramApi::getCaption($post);
        $postObj->permaLink = InstagramApi::getPermaLink($post, $this->account);
        $postObj->mediaUrl = InstagramApi::getPicture($post);
        $postObj->mediaType = InstagramApi::getMediaType($post);
    }

//    protected function saveImage($mediaId, $post) {
//        $targetFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $this->imageDir . DIRECTORY_SEPARATOR . $mediaId . '.jpg';
//
//        $sourceUrl = ($post['media_type'] == 'VIDEO') ? $post['thumbnail_url'] : $post['media_url'];
//        $sourceData = $this->file_get_contents_curl($sourceUrl);
//
//        file_put_contents($targetFile, $sourceData);
//    }
//
//    protected function file_get_contents_curl($url) {
//        $ch = curl_init();
//
//        curl_setopt($ch, CURLOPT_HEADER, 0);
//        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
//        curl_setopt($ch, CURLOPT_URL, $url);
//
//        $data = curl_exec($ch);
//        curl_close($ch);
//
//        return $data;
//    }
//
//    protected function logRun() {
//        if ($this->config['command']) {
//            $entryStr = sprintf('%s - Instagram Feed: %s', date('d.m.Y H:i:s'), $this->accountName);
//            echo $entryStr . "\n";
//        }
//    }
//
//    protected function logPost($post, $action) {
//        if ($this->config['command'] && $this->config['output']) {
//            $entryStr = sprintf('%s [%s] - %s / %s / %s', date('d.m.Y H:i:s'), $action, $this->accountName, $post['id'], substr($post['caption'], 0, 40));
//            echo $entryStr . "\n";
//        }
//    }
}
