<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Elements;

use Contao\ContentModel;
use Contao\FilesModel;
use Contao\Controller;
use Contao\System;
use Contao\CoreBundle\Controller\ContentElement\AbstractContentElementController;
use Contao\CoreBundle\ServiceAnnotation\ContentElement;
use Contao\Template;
use Dmkzwo\ContaoSocialmediaBundle\Model\YoutubeAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\YoutubePostModel;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @ContentElement(YoutubeListElementController::TYPE)
 */
class YoutubeListElementController extends AbstractSocialMediaListElementController
{
    public const TYPE = 'youtube_list_element';

    protected $accountType = 'youtube';

    protected function getAccount($model)
    {
        return YoutubeAccountModel::findByPk($model->dzSmYoutubeFeed);

    }

    protected function getFeedEntries($model)
    {
        $account = YoutubeAccountModel::findByPk($model->dzSmYoutubeFeed);

        $entries = false;

        if ($account) {
            $entries = YoutubePostModel::findBy(
                ['pid=?', 'published=?'],
                [$account->id, '1'],
                [
                    'order' => 'tstamp desc',
                    'limit' => $model->dzSmNumItems
                ]
            );
        }

        return $entries;
    }

}

