<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Elements;

use Contao\ContentModel;
use Contao\FilesModel;
use Contao\Controller;
use Contao\System;
use Contao\CoreBundle\Controller\ContentElement\AbstractContentElementController;
use Contao\CoreBundle\ServiceAnnotation\ContentElement;
use Contao\Template;
use Dmkzwo\ContaoSocialmediaBundle\Model\TwitterAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\TwitterPostModel;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @ContentElement(TwitterListElementController::TYPE)
 */
class TwitterListElementController extends AbstractSocialMediaListElementController
{
    public const TYPE = 'twitter_list_element';

    protected $accountType = 'twitter';


    protected function getAccount($model)
    {
        return TwitterAccountModel::findByPk($model->dzSmTwitterFeed);
    }

    protected function getFeedEntries($model)
    {
        $account = TwitterAccountModel::findByPk($model->dzSmTwitterFeed);

        $entries = false;

        if ($account) {
            $entries = TwitterPostModel::findBy(
                ['pid=?', 'published=?'],
                [$account->id, '1'],
                [
                    'order' => 'tstamp desc',
                    'limit' => $model->dzSmNumItems
                ]
            );
        }

        return $entries;
    }

}

