<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Elements;

use Contao\ContentModel;
use Contao\FilesModel;
use Contao\Controller;
use Contao\System;
use Contao\CoreBundle\Controller\ContentElement\AbstractContentElementController;
use Contao\CoreBundle\ServiceAnnotation\ContentElement;
use Contao\Template;
use Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\InstagramPostModel;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @ContentElement(InstagramListElementController::TYPE)
 */
class InstagramListElementController extends AbstractSocialMediaListElementController
{
    public const TYPE = 'instagram_list_element';

    protected $accountType = 'instagram';

    protected function getAccount($model)
    {
        return InstagramAccountModel::findByPk($model->dzSmInstagramFeed);

    }

    protected function getFeedEntries($model)
    {
        $account = InstagramAccountModel::findByPk($model->dzSmInstagramFeed);

        $entries = false;

        if ($account) {
            $entries = InstagramPostModel::findBy(
                ['pid=?', 'published=?'],
                [$account->id, '1'],
                [
                    'order' => 'tstamp desc',
                    'limit' => $model->dzSmNumItems
                ]
            );
        }

        return $entries;
    }

}

