<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Elements;

use Contao\ContentModel;
use Contao\FilesModel;
use Contao\Controller;
use Contao\System;
use Contao\CoreBundle\Controller\ContentElement\AbstractContentElementController;
use Contao\CoreBundle\ServiceAnnotation\ContentElement;
use Contao\Template;
use Dmkzwo\ContaoSocialmediaBundle\Model\FacebookAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\FacebookPostModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\FlickrPostModel;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @ContentElement(FacebookListElementController::TYPE)
 */
class FacebookListElementController extends AbstractSocialMediaListElementController
{
    public const TYPE = 'facebook_list_element';

    protected $accountType = 'facebook';

    protected function getAccount($model)
    {
        return FacebookAccountModel::findByPk($model->dzSmFacebookFeed);

    }

    protected function getFeedEntries($model)
    {
        $account = FacebookAccountModel::findByPk($model->dzSmFacebookFeed);

        $entries = false;

        if ($account) {
            $entries = FacebookPostModel::findBy(
                ['pid=?', 'published=?'],
                [$account->id, '1'],
                [
                    'order' => 'tstamp desc',
                    'limit' => $model->dzSmNumItems
                ]
            );
        }

        return $entries;
    }

}

