<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Classes;

abstract class SocialmediaPostBackend extends \Backend
{

    abstract public function getPost($id);

    /**
     * Import the back end user object
     */
    public function __construct()
    {
        parent::__construct();
        $this->import('Contao\BackendUser', 'User');
    }

    /**
     * Check permissions to edit table tl_dz_socialmedia_youtube_post
     */
    public function checkPermission()
    {
        $bundles = \System::getContainer()->getParameter('kernel.bundles');

    }

//    public function customLabel($row, $label) {
//        $mediaFile = \Dmkzwo\ContaoSocialmediaBundle\Library\SocialmediaHelper::existImage($row['mediaSrc']);
//
//        if ($mediaFile) {
//            $label = sprintf('<div style="display: flex;"><img src="/%s" style="max-width: 150px; height: auto;"><p style="margin-left: 10px;"><strong>%s - %s</strong><br><br>%s</p></div>', $mediaFile, $row['accountId'], date('d.m.Y H:i:s', $row['tstamp']), $row['message']);
//        }
//
//        return $label;
//    }

    public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (strlen(\Input::get('tid'))) {
            $this->setVisibility(\Input::get('tid'), (\Input::get('state') == 1));
            $this->redirect($this->getReferer());
        }

        $href .= '&tid=' . $row['id'] . '&state=' . ($row['published'] ? 0 : 1);

        if (!$row['published']) {
            $icon = 'invisible.gif';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '" ' . $attributes . '>' . \Image::getHtml($icon, $label, 'data-state="' . ($row['published'] ? 1 : 0) . '"') . '</a> ';
    }

    public function setVisibility($id, $isVisible)
    {
        $post = $this->getPost($id);
        $post->published = $isVisible ? 1 : 0;
        $post->save();
    }

    public function toggleHideOnWall($row, $href, $label, $title, $icon, $attributes)
    {
        if (strlen(\Input::get('hid'))) {
            $this->setHideOnWall(\Input::get('hid'), (\Input::get('state') == 1));
            $this->redirect($this->getReferer());
        }

        $href .= '&hid=' . $row['id'] . '&state=' . ($row['hideOnWall'] ? 0 : 1);

        if (!$row['hideOnWall']) {
            $icon = 'visible.gif';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '" ' . $attributes . '>' . \Image::getHtml($icon, $label, 'data-state="' . ($row['hideOnWall'] ? 1 : 0) . '"') . '</a> ';
    }

    public function setHideOnWall($id, $isVisible)
    {
        $post = $this->getPost($id);
        $post->hideOnWall = $isVisible ? 1 : 0;
        $post->save();
    }

//    public function pasteElement(DataContainer $dc, $row, $table, $cr, $arrClipboard)
//    {
//        $imagePasteAfter = Image::getHtml('pasteafter.gif',
//            sprintf($GLOBALS['TL_LANG'][$table]['pasteafter'][1], $row['id']));
//        return '<a href="' . $this->addToUrl('act=' . $arrClipboard['mode'] . '&mode=1&pid=' . $row['id']) . '" title="' . specialchars(sprintf($GLOBALS['TL_LANG'][$table]['pasteafter'][1],
//                $row['id'])) . '" onclick="Backend.getScrollOffset()">' . $imagePasteAfter . '</a> ';
//    }

}
