<?php


namespace Dmkzwo\ContaoSocialmediaBundle\Classes;


use Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel;

class SocialmediaDca
{
    public static function getTwitterAccountBackendOptions()
    {
        return self::getSocialMediaAccountBackendOptions('Dmkzwo\ContaoSocialmediaBundle\Model\TwitterAccountModel');
    }

    public static function getFlickrAccountBackendOptions()
    {
        return self::getSocialMediaAccountBackendOptions('Dmkzwo\ContaoSocialmediaBundle\Model\FlickrAccountModel');
    }

    public static function getFacebookAccountBackendOptions()
    {
        return self::getSocialMediaAccountBackendOptions('Dmkzwo\ContaoSocialmediaBundle\Model\FacebookAccountModel');
    }

    public static function getInstagramAccountBackendOptions()
    {
        return self::getSocialMediaAccountBackendOptions('Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel');
    }

    public static function getYoutubeAccountBackendOptions()
    {
        return self::getSocialMediaAccountBackendOptions('Dmkzwo\ContaoSocialmediaBundle\Model\YoutubeAccountModel');
    }

    public static function getSocialMediaAccountBackendOptions($accountClassname)
    {
        $accounts = $accountClassname::findAll();

        $options = [];

        foreach ($accounts as $isAccount) {
            $options[$isAccount->id] = $isAccount->accountName;
        }

        return $options;
    }

    public function getAccountBackendOptions()
    {
        $isAccounts = InstagramAccountModel::findAll();


        $options = [];

        foreach ($isAccounts as $isAccount) {
            $options[$isAccount->userId] = $isAccount->accountName;
        }

        return $options;
    }

    public function getNumStartOptions()
    {
        $options = ['-1' => 'Alle'];

        for ($i=1; $i<=10; $i++) {
            $options['' . $i] = $i;
        }

        return $options;
    }

    public static function getAccountDca() {
        $dca = array
        (

            // Config
            'config' => array
            (
                'dataContainer' => 'Table',
                'enableVersioning' => true,
//        'onload_callback' => array
//        (
//            array('tl_dz_socialmedia_youtube', 'checkPermission')
//        ),
                'sql' => array
                (
                    'keys' => array
                    (
                        'id' => 'primary',
                    )
                )
            ),

            // List
            'list' => array
            (
                'sorting' => array
                (
                    'mode' => 2,
                    'fields' => array('accountName'),
                    'panelLayout' => 'sort,search;filter;limit',
                    //'headerFields'            => array('name_de', 'name_en'),
//            'paste_button_callback' => array('tl_dz_socialmedia_youtube', 'pasteElement'),
                    'disableGrouping' => true,
                ),
                'label' => array
                (
                    'fields' => array('accountName'),
                    'format' => '%s',
                    'showColumns' => true,
//            'label_callback' => array('tl_dz_socialmedia_youtube', 'generateLabel'),
                ),
                'global_operations' => array
                (
//            'all' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
//                'href' => 'act=select',
//                'class' => 'header_edit_all',
//                'attributes' => 'onclick="Backend.getScrollOffset()" accesskey="e"'
//            )
                ),
                'operations' => array
                (
                    'edit' => array
                    (
                        'label' => &$GLOBALS['TL_LANG']['tl_content']['edit'],
                        'href' => 'act=edit',
                        'icon' => 'edit.svg'
                    ),
//            'copy' => array
//          public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
//    {
//        if (strlen(Input::get('tid'))) {
//            $this->setVisibility(Input::get('tid'), (Input::get('state') == 1));
//            $this->redirect($this->getReferer());
//        }
//
//        $href .= '&tid=' . $row['id'] . '&state=' . ($row['published'] ? 0 : 1);
//
//        if (!$row['published']) {
//            $icon = 'invisible.gif';
//        }
//
//        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '" ' . $attributes . '>' . Image::getHtml($icon, $label, 'data-state="' . ($row['published'] ? 1 : 0) . '"') . '</a> ';
//    }
//
//    public function setVisibility($id, $isVisible)
//    {
//        $post = \Dmkzwo\ContaoSocialmediaBundle\Model\InstagramPostModel::findByPk($id);
//        $post->published = $isVisible ? 1 : 0;
//        $post->save();
//    }      (
//                'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_youtube']['copy'],
//                'href' => 'act=paste&amp;mode=copy',
//                'icon' => 'copy.svg'
//            ),
//            'cut' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_youtube']['cut'],
//                'href' => 'act=paste&amp;mode=cut',
//                'icon' => 'cut.svg'
//            ),
                    'delete' => array
                    (
                        'label' => &$GLOBALS['TL_LANG']['tl_content']['delete'],
                        'href' => 'act=delete',
                        'icon' => 'delete.svg',
                        'attributes' => 'onclick="if(!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\'))return false;Backend.getScrollOffset()"'
                    ),
                    'toggle' => array
                    (
                        'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_youtube']['toggle'],
                        'icon' => 'visible.svg',
                        'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
//                        'button_callback' => array('tl_dz_socialmedia_youtube', 'toggleIcon')
                    ),
                    'show' => array
                    (
                        'label' => &$GLOBALS['TL_LANG']['tl_content']['show'],
                        'href' => 'act=show',
                        'icon' => 'show.svg'
                    )
                )
            ),

            // Palettes
            'palettes' => array
            (
            ),


// Fields
            'fields' => array
            (
                'id' => array
                (
                    'sql' => "int(10) unsigned NOT NULL auto_increment"
                ),
                'tstamp' => array
                (
                    'sql' => "int(10) unsigned NOT NULL default 0"
                ),
                'published' => array
                (
                    'exclude' => true,
                    'filter' => true,
                    'flag' => 2,
                    'inputType' => 'checkbox',
                    'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
                    'sql' => "char(1) NOT NULL default '1'"
                ),
                'cronInterval' => array
                (
                    'exclude' => false,
                    'inputType' => 'radio',
                    'options' => ['0' => 'deaktiviert', '10' => 'alle 10 Minuten', '60' => 'alle 60 Minuten', '1440' => 'täglich', '-1' => 'immer (Development-Mode)'],
                    'default' => 0,
                    'eval' => array('mandatory' => true, 'tl_class' => 'clr w50', 'isAssociative' => true),
                    'sql' => "int(10) NOT NULL default '0'"
                ),
                'cronLastrun' => array
                (
                    'sql' => "int(10) unsigned NOT NULL default 0"
                ),
                'accountName' => array
                (
                    'exclude' => false,
                    'sorting' => true,
                    'inputType' => 'text',
                    'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
                    'sql' => "varchar(255) NOT NULL default ''"
                ),
                'publishMode' => array
                (
                    'exclude' => false,
                    'inputType' => 'radio',
                    'options' => ['whitelist', 'blacklist'],
                    'eval' => array('mandatory' => true, 'tl_class' => 'clr w50'),
                    'sql' => "varchar(16) NOT NULL default 'blacklist'"
                ),
//                'imageSrc' => array
//                (
//                    'exclude' => false,
//                    'inputType' => 'fileTree',
//                    'eval' => array('mandatory' => true, 'filesOnly' => true, 'fieldType' => 'radio', 'tl_class' => 'clr w50'),
//                    'sql' => "binary(16) NULL"
//                ),
                'notifyOnError' => array
                (
                    'exclude' => false,
                    'inputType' => 'text',
                    'eval' => array('mandatory' => false, 'maxlength' => 255, 'tl_class' => 'clr w50'),
                    'sql' => "varchar(255) NOT NULL default ''"
                ),
                'notificationDisabled' => array
                (
                    'exclude' => true,
                    'inputType' => 'checkbox',
                    'eval' => array('doNotCopy' => true, 'tl_class' => 'm12 w50'),
                    'sql' => "char(1) NOT NULL default ''"
                ),

            )
        );

        return $dca;
    }

    public static function getPostDca() {
        $dca = array
        (
            'config' => array
            (
                'dataContainer' => 'Table',
                'enableVersioning' => true,
//        'onload_callback' => array
//        (
//            array('tl_dz_socialmedia_youtube_post', 'checkPermission')
//        ),
                'sql' => array
                (
                    'keys' => array
                    (
                        'id' => 'primary',
                    )
                )
            ),

            // List
            'list' => array
            (
                'sorting' => array
                (
                    'mode' => 2,
                    'fields' => array('tstamp'),
                    'panelLayout' => 'sort,search;filter;limit',
                    //'headerFields'            => array('name_de', 'name_en'),
//            'paste_button_callback' => array('tl_dz_socialmedia_youtube_post', 'pasteElement'),
                    'disableGrouping' => true,
                ),
                'label' => array
                (
                    'fields' => array('message'),
                    'format' => '%s',
                    'showColumns' => true,
//                    'label_callback' => ['tl_dz_socialmedia_youtube_post', 'customLabel']
//            'label_callback' => array('tl_dz_socialmedia_youtube_post', 'generateLabel'),
                ),
                'global_operations' => array
                (
//            'all' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
//                'href' => 'act=select',
//                'class' => 'header_edit_all',
//                'attributes' => 'onclick="Backend.getScrollOffset()" accesskey="e"'
//            )
                ),
                'operations' => array
                (
//            'edit' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['tl_content']['edit'],
//                'href' => 'act=edit',
//                'icon' => 'edit.svg'
//            ),
//            'copy' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_youtube_post']['copy'],
//                'href' => 'act=paste&amp;mode=copy',
//                'icon' => 'copy.svg'
//            ),
//            'cut' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_youtube_post']['cut'],
//                'href' => 'act=paste&amp;mode=cut',
//                'icon' => 'cut.svg'
//            ),
//            'delete' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['tl_content']['delete'],
//                'href' => 'act=delete',
//                'icon' => 'delete.svg',
//                'attributes' => 'onclick="if(!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\'))return false;Backend.getScrollOffset()"'
//            ),
                    'toggle' => array
                    (
                        'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_youtube_post']['toggle'],
                        'icon' => 'visible.svg',
                        'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
//                        'button_callback' => array('tl_dz_socialmedia_youtube_post', 'toggleIcon')
                    ),
                    'toggleHide' => array
                    (
                        'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_youtube_post']['toggleHide'],
                        'icon' => 'invisible.svg',
//                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
//                        'button_callback' => array('tl_dz_socialmedia_youtube_post', 'toggleHideOnWall')
                    ),
                    'show' => array
                    (
                        'label' => &$GLOBALS['TL_LANG']['tl_content']['show'],
                        'href' => 'act=show',
                        'icon' => 'show.svg'
                    )
                )
            ),

            // Palettes
            'palettes' => array
            (
//        'default'                     => 'name_de,name_en;{publish_legend},published'
//        '__selector__' => ['addcoverimage'],
//        'default' => 'title,alias,identifier,releasedate,docfile,language,targetsd,targetev,published,description,longdescription,addcoverimage;{meta_legend},types,doctypes,allcategories,categories'
                'default' => 'postId,published'
            ),

//    'subpalettes' => array
//    (
//        'addcoverimage' => 'coverimage',
//    ),


// Fields
            'fields' => array
            (
                'id' => array
                (
                    'sql' => "int(10) unsigned NOT NULL auto_increment"
                ),
                'pid' => array
                (
                    'sql' => "int(10) unsigned NOT NULL default '0'"
                ),
                'accountId' => array
                (
                    'sql' => "int(10) unsigned NOT NULL default 0",
                    'filter' => true
                ),
                'tstamp' => array
                (
                    'flag' => 12,
                    'sql' => "int(10) unsigned NOT NULL default 0"
                ),
                'published' => array
                (
                    'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_youtube_post']['published'],
                    'exclude' => true,
                    'filter' => true,
                    'flag' => 2,
                    'inputType' => 'checkbox',
                    'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
                    'sql' => "char(1) NOT NULL default ''"
                ),
                'hideOnWall' => array
                (
                    'exclude' => true,
                    'inputType' => 'checkbox',
                    'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
                    'sql' => "char(1) NOT NULL default ''"
                ),
                'postId' => array
                (
                    'exclude' => false,
                    'sorting' => false,
                    'inputType' => 'text',
                    'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
                    'sql' => "varchar(255) NOT NULL default ''"
                ),
                'mediaUrl' => array
                (
                    'exclude' => false,
                    'sorting' => false,
                    'inputType' => 'text',
                    'eval' => array('mandatory' => true, 'tl_class' => 'w50'),
                    'sql' => "text NULL"
                ),
                'mediaSrc' => array
                (
                    'exclude' => false,
                    'sorting' => false,
                    'inputType' => 'text',
                    'eval' => array('mandatory' => true, 'tl_class' => 'w50'),
                    'sql' => "text NULL"
                ),
                'permaLink' => array
                (
                    'exclude' => false,
                    'sorting' => false,
                    'inputType' => 'text',
                    'eval' => array('mandatory' => true, 'tl_class' => 'w50'),
                    'sql' => "text NULL"
                ),

            )
        );

        return $dca;
    }

}
