<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Classes;

class FlickrApi
{
    private $flickrApiKey;
    private $queryParam;

    protected $flickrAccessDataFound = false;
    protected $twitterSession;

    /**
     * InstagramApi constructor.
     * @param $params
     */
    public function __construct($account)
    {
        $this->flickrApiKey= $account->flickrApiKey;
        $this->queryParam = $account->queryParam;

        if (!(strlen($this->flickrApiKey) && ($this->queryParam))) {
            throw new \Exception('API/Feed configuration incomplete');
        }

    }

    public function getFeeds($debug = false) {

        $params = array(
            'method'	=> 'flickr.people.getPublicPhotos',
            'user_id'	=> $this->queryParam,
        );

        $photoset = $this->flickrPhpRequest($params);

        $entries = array();

        if ($photoset['stat'] == 'ok') {
            $photos = $photoset['photos']['photo'];

            $photos = array_slice($photos, 0, 20);

            foreach ($photos as $entry) {
                $photo_id = $entry['id'];

                $params = array(
                    'method'	=> 'flickr.photos.getInfo',
                    'photo_id'	=> $photo_id,
                );

                $photo = $this->flickrPhpRequest($params);
                array_push($entries, $photo['photo']);

            }
        }

        if ($debug) {
            var_dump($entries);
            die();
        }

        return $entries;

    }

    protected function flickrPhpRequest($params) {

        $addParams = array(
            'api_key'	=> $this->flickrApiKey,
            'format'	=> 'php_serial',
        );

        $params = array_merge($params, $addParams);

        $encoded_params = array();

        foreach ($params as $k => $v){
            $encoded_params[] = urlencode($k).'='.urlencode($v);
        }


        $url = "https://api.flickr.com/services/rest/?".implode('&', $encoded_params);

        $rsp = file_get_contents($url);

        return unserialize($rsp);

    }


    public static function getId($post) {
        return $post['id'];
    }

    public static function getUnixTimestamp($post) {
        return $post['dates']['posted'];
    }

    public static function getCreatedTime($post) {
//        return $post['dates']['lastupdate'];
        return $post['dates']['posted'];
    }

    public static function getTitle($post) {
        return $post['title']['_content'];
    }

    public static function getMessage($post) {
        return $post['description']['_content'];
    }

    public static function getPicture($post) {
        return sprintf("https://farm%s.staticflickr.com/%s/%s_%s_t.jpg", $post['farm'], $post['server'], $post['id'], $post['secret']);
    }

    public static function getPermaLink($post) {
        return $post['urls']['url'][0]['_content'];
    }

}
