<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Classes;

abstract class SocialmediaAccountBackend extends \Backend
{

    abstract public function getAccount($id);

    /**
     * Import the back end user object
     */
    public function __construct()
    {
        parent::__construct();
        $this->import('Contao\BackendUser', 'User');
    }

    /**
     * Check permissions to edit table tl_dz_socialmedia_youtube
     */
    public function checkPermission()
    {
        $bundles = \System::getContainer()->getParameter('kernel.bundles');

    }

    public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (strlen(\Input::get('tid'))) {
            $this->setVisibility(\Input::get('tid'), (\Input::get('state') == 1));
            $this->redirect($this->getReferer());
        }

        $href .= '&tid=' . $row['id'] . '&state=' . ($row['published'] ? 0 : 1);

        if (!$row['published']) {
            $icon = 'invisible.gif';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '" ' . $attributes . '>' . \Image::getHtml($icon, $label, 'data-state="' . ($row['published'] ? 1 : 0) . '"') . '</a> ';
    }

    public function setVisibility($id, $isVisible)
    {
        $post = $this->getAccount($id);
        $post->published = $isVisible ? 1 : 0;
        $post->save();
    }

//    public function pasteElement(DataContainer $dc, $row, $table, $cr, $arrClipboard)
//    {
//        $imagePasteAfter = Image::getHtml('pasteafter.gif',
//            sprintf($GLOBALS['TL_LANG'][$table]['pasteafter'][1], $row['id']));
//        return '<a href="' . $this->addToUrl('act=' . $arrClipboard['mode'] . '&mode=1&pid=' . $row['id']) . '" title="' . specialchars(sprintf($GLOBALS['TL_LANG'][$table]['pasteafter'][1],
//                $row['id'])) . '" onclick="Backend.getScrollOffset()">' . $imagePasteAfter . '</a> ';
//    }

}
